package com.meidusa.toolkit.net;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

import com.meidusa.toolkit.common.heartbeat.Status;

public abstract class ValidatorMessageHandler<T> implements MessageHandler<BackendConnection, T> {

	private CountDownLatch latch = new CountDownLatch(1);
	private Status status;

	protected void setStatus(Status status) {
		this.status = status;
		latch.countDown();
	}

	protected Status getResult(BackendConnection conn) {
		try {
			latch.await(2, TimeUnit.SECONDS);
		} catch (InterruptedException e) {
		}

		return status;
	}
	
	protected abstract void doCheck(BackendConnection conn);

}