package com.meidusa.toolkit.net;

import java.util.concurrent.TimeUnit;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.meidusa.toolkit.common.heartbeat.HeartbeatDelayed;
import com.meidusa.toolkit.common.heartbeat.Status;

public interface BackendConnectionPool {

	public abstract String getName();

	public abstract BackendConnection borrowObject() throws Exception;

	public abstract void returnObject(BackendConnection c);

	public abstract void close();

	public abstract int getActive();

	public void deActive(BackendConnection c);

	public abstract boolean isValid();
	
	//public abstract boolean validate();

	public abstract void setValid(boolean b);

	public abstract void init();
	
	public boolean isClosed();
	
	public static class ObjectPoolHeartbeatDelayed extends HeartbeatDelayed {
		protected static Logger logger = LoggerFactory.getLogger(ObjectPoolHeartbeatDelayed.class);
        protected BackendConnectionPool                    pool;
        
        public boolean isCycle(){
        	return false;
        }
        
        public BackendConnectionPool getPool() {
			return pool;
		}

		public ObjectPoolHeartbeatDelayed(long nsTime, TimeUnit timeUnit, BackendConnectionPool pool){
			super(nsTime,timeUnit);
            this.pool = pool;
        }

	    public boolean equals(Object obj) {
	    	if(obj instanceof ObjectPoolHeartbeatDelayed){
	    		ObjectPoolHeartbeatDelayed other = (ObjectPoolHeartbeatDelayed)obj;
	    		return other.pool == this.pool && this.getClass() == obj.getClass();
	    	}else{
	    		return false;
	    	}
        }
	    
	    public int hashCode(){
	    	return pool == null?this.getClass().hashCode():this.getClass().hashCode() + pool.hashCode();
	    }
	    
        
        public Status doCheck() {
        	BackendConnection conn = null;
			try {
				conn = pool.borrowObject();
				if(conn != null){
				
					if(conn.isClosed()){
						pool.setValid(false);
						return Status.INVALID;
					}else{
						pool.setValid(true);
						return Status.VALID;
					}
				}else{
					return Status.INVALID;
				}
			} catch (Exception e) {
				logger.warn(e.getMessage(), e);
				pool.setValid(false);
				return Status.INVALID;
			}finally{
				if(conn != null){
					pool.returnObject(conn);
				}
			}
        	
        }

		@Override
		public String getName() {
			return this.pool.getName();
		}
	}

}