/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.net.util;

import com.meidusa.toolkit.net.util.Queue;

public class MemoryQueue<T>
implements Queue<T> {
    protected static final int MIN_SHRINK_SIZE = 1024;
    protected int maxSize = -1;
    protected T[] _items;
    protected int _count = 0;
    protected int _start = 0;
    protected int _end = 0;
    protected int _suggestedSize;
    protected int _size = 0;

    public MemoryQueue(int suggestedSize) {
        this._size = this._suggestedSize = suggestedSize;
        this._items = this.newArray(this._size);
    }

    public MemoryQueue(int suggestedSize, int maxSize) {
        this._size = this._suggestedSize = suggestedSize;
        this._items = this.newArray(this._size);
        this.maxSize = maxSize;
    }

    public MemoryQueue() {
        this(4);
    }

    @Override
    public synchronized void clear() {
        this._end = 0;
        this._start = 0;
        this._count = 0;
        this._size = this._suggestedSize;
        this._items = this.newArray(this._size);
    }

    public synchronized boolean hasElements() {
        return this._count != 0;
    }

    @Override
    public synchronized int size() {
        return this._count;
    }

    @Override
    public synchronized void prepend(T item) {
        if (this._count == this._size) {
            this.makeMoreRoom();
        }
        this._start = this._start == 0 ? this._size - 1 : --this._start;
        this._items[this._start] = item;
        ++this._count;
    }

    @Override
    public synchronized void append(T item) {
        this.append0(item, false);
    }

    protected void append0(T item, boolean notify) {
        while (this._count >= this.maxSize && this.maxSize > 0) {
            try {
                this.wait(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this._count == this._size) {
            this.makeMoreRoom();
        }
        this._items[this._end] = item;
        this._end = (this._end + 1) % this._size;
        ++this._count;
        if (notify) {
            this.notify();
        }
    }

    @Override
    public synchronized T getNonBlocking() {
        if (this._count == 0) {
            return null;
        }
        T retval = this._items[this._start];
        this._items[this._start] = null;
        this._start = (this._start + 1) % this._size;
        --this._count;
        return retval;
    }

    protected void makeMoreRoom() {
        T[] items = this.newArray(this._size * 2);
        System.arraycopy(this._items, this._start, items, 0, this._size - this._start);
        System.arraycopy(this._items, 0, items, this._size - this._start, this._end);
        this._start = 0;
        this._end = this._size;
        this._size *= 2;
        this._items = items;
    }

    protected void shrink() {
        T[] items = this.newArray(this._size / 2);
        if (this._start > this._end) {
            System.arraycopy(this._items, this._start, items, 0, this._size - this._start);
            System.arraycopy(this._items, 0, items, this._size - this._start, this._end + 1);
        } else {
            System.arraycopy(this._items, this._start, items, 0, this._end - this._start + 1);
        }
        this._size /= 2;
        this._start = 0;
        this._end = this._count;
        this._items = items;
    }

    private T[] newArray(int size) {
        return new Object[size];
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[count=").append(this._count);
        buf.append(", size=").append(this._size);
        buf.append(", start=").append(this._start);
        buf.append(", end=").append(this._end);
        buf.append(", elements={");
        for (int i = 0; i < this._count; ++i) {
            int pos = (i + this._start) % this._size;
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(this._items[pos]);
        }
        return buf.append("}]").toString();
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }
}

