/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.net.util;

import com.meidusa.toolkit.net.util.StringUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IPRule {
    private static final Map<String, Pattern> ipPattern = new HashMap<String, Pattern>();

    public static boolean IsAllowIP(String rule, String ip) throws Exception {
        String[] ruleArray = StringUtil.split(rule, ";");
        return IPRule.isAllowIP(ruleArray, ip);
    }

    public static boolean isAllowIP(String[] ruleArray, String ip) throws Exception {
        String ipRegexString = "^((2[0-4][0-9]|25[0-5]|[01]?[0-9][0-9]?).){3}(2[0-4][0-9]|25[0-5]|[01]?[0-9][0-9]?)$";
        if (!Regex.IsMatch(ip, ipRegexString)) {
            throw new Exception("\u53c2\u6570ip\u9519\u8bef\uff1a\u9519\u8bef\u7684IP\u5730\u5740" + ip);
        }
        String[] ipdata = StringUtil.split(ip, ".");
        boolean retValue = false;
        for (String s : ruleArray) {
            boolean IsFind = false;
            String[] data = StringUtil.split(s, ':');
            if (data.length != 2) {
                throw new Exception("\u8bf7\u7528:\u5206\u5f00 \u5982:192.168.1.1:yes");
            }
            String ruleIp = data[0];
            retValue = data[1].equalsIgnoreCase("yes");
            String[] ruleIpArray = StringUtil.split(ruleIp, '.');
            if (ruleIpArray.length != 4) {
                throw new Exception("IP\u90e8\u5206\u9519\u8bef\uff01");
            }
            for (int i = 0; i < 4; ++i) {
                Object temp;
                boolean AA = ruleIpArray[i].contains("*");
                boolean BB = ruleIpArray[i].contains("-");
                boolean CC = ruleIpArray[i].contains("?");
                if (AA && BB || AA && CC || BB && CC || AA && BB && CC) {
                    throw new Exception("\u8fd9\u6837\u7684\u683c\u5f0f\u662f\u9519\u8bef\u7684,192.168.15-20*,*\u4e0e-\u4e0d\u80fd\u5305\u542b\u5728\u540c\u4e00\u4e2a\u90e8\u5206! ");
                }
                if (!(AA || BB || CC)) {
                    if (!Regex.IsMatch(ruleIpArray[i], "^2[0-4][0-9]|25[0-5]|[01]?[0-9][0-9]?$")) {
                        throw new Exception("IP\u6bb5\u9519\u8bef\u5e94\u8be5\u57281~255\u4e4b\u95f4:" + ruleIpArray[i]);
                    }
                    if (ruleIpArray[i].equalsIgnoreCase(ipdata[i])) {
                        IsFind = true;
                        continue;
                    }
                    IsFind = false;
                    break;
                }
                if (AA && !BB && !CC) {
                    if (!ruleIpArray[i].equalsIgnoreCase("*")) {
                        if (!ruleIpArray[i].startsWith("*") && ruleIpArray[i].endsWith("*") && !ruleIpArray[i].contains("**")) continue;
                        throw new Exception("IP\u4e2d\u7684*\u90e8\u5206\uff1a\u4e0d\u80fd\u4ee5*\u5f00\u5934\uff0c\u4e0d\u80fd\u6709\u4e24\u4e2a**\uff0c\u53ea\u80fd\u4ee5*\u7ed3\u5c3e");
                    }
                    if (ipdata[i].startsWith(ruleIpArray[i].replace("*", ""))) {
                        IsFind = true;
                        continue;
                    }
                    IsFind = false;
                    break;
                }
                if (BB && !AA && !CC) {
                    temp = StringUtil.split(ruleIpArray[i], '-');
                    if (((String[])temp).length != 2) {
                        throw new Exception("IP\u6bb5\u9519\u8bef, \u5982:23-50,\u57281~255\u4e4b\u95f4");
                    }
                    int[] nums = new int[]{Integer.parseInt(temp[0]), Integer.parseInt((String)temp[1])};
                    if (nums[0] < 1 || nums[1] > 255) {
                        throw new Exception("IP\u6bb5\u9519\u8bef, \u5982:23-50,\u57281~255\u4e4b\u95f4");
                    }
                    int ipNum = Integer.parseInt(ipdata[i]);
                    if (ipNum >= nums[0] && ipNum <= nums[1]) {
                        IsFind = true;
                        continue;
                    }
                    IsFind = false;
                    break;
                }
                if (CC && !AA & !BB) {
                    temp = ruleIpArray[i].replace("?", "");
                    if (!Regex.IsMatch((String)temp, "^[0-9][0-9]?$") || ((String)temp).length() > 2) {
                        throw new Exception("IP\u6bb5\u9519\u8bef:" + ruleIpArray[i]);
                    }
                    if (ruleIpArray[i].length() != ipdata[i].length()) {
                        IsFind = false;
                        break;
                    }
                    String tempRegstring = "^" + ruleIpArray[i].replace("?", "([0-9])*") + "$";
                    if (Regex.IsMatch(ipdata[i], tempRegstring)) {
                        IsFind = true;
                        continue;
                    }
                    IsFind = false;
                    break;
                }
                IsFind = false;
                break;
            }
            if (!IsFind) continue;
            return retValue;
        }
        return false;
    }

    public static void main(String[] args) {
        try {
            long start = System.currentTimeMillis();
            for (int i = 0; i < 1; ++i) {
                IPRule.IsAllowIP("192.*.1.236-239:yes", "192.84.1.226");
            }
            System.out.println(System.currentTimeMillis() - start);
            start = System.currentTimeMillis();
            IPRegex regex = new IPRegex("192.1*.1.236-239");
            for (int i = 0; i < 1000000; ++i) {
                regex.isMatch("192.181.1.236");
            }
            System.out.println(System.currentTimeMillis() - start);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static class Regex {
        Regex() {
        }

        static boolean IsMatch(String ip, String ipRegexString) {
            Pattern pattern = (Pattern)ipPattern.get(ipRegexString);
            if (pattern == null) {
                pattern = Pattern.compile(ipRegexString);
                ipPattern.put(ipRegexString, pattern);
            }
            Matcher m = pattern.matcher(ip);
            return m.matches();
        }
    }

    static class IPRegex
    implements IPPattern {
        IPPattern[] patterns = new IPPattern[4];

        public IPRegex(String ip) {
            String[] tmps = StringUtil.split(ip, '.');
            for (int i = 0; i < tmps.length; ++i) {
                this.patterns[i] = tmps[i].contains("-") ? new SegmentPattern(tmps[i]) : (tmps[i].contains("*") ? new StarPattern(tmps[i]) : new NumPattern(tmps[i]));
            }
        }

        @Override
        public boolean isMatch(String ip) {
            String[] tmps = StringUtil.split(ip, '.');
            for (int i = 0; i < tmps.length; ++i) {
                if (this.patterns[i].isMatch(tmps[i])) continue;
                return false;
            }
            return true;
        }
    }

    static class StarPattern
    implements IPPattern {
        String starString;

        public StarPattern(String ipRegexString) {
            this.starString = StringUtil.replace(ipRegexString, "*", "");
        }

        @Override
        public boolean isMatch(String ip) {
            return ip.startsWith(this.starString);
        }
    }

    static class SegmentPattern
    implements IPPattern {
        int begin;
        int end;

        public SegmentPattern(String string) {
            String[] temp = StringUtil.split(string, '-');
            this.begin = Integer.parseInt(temp[0]);
            this.end = Integer.parseInt(temp[1]);
        }

        @Override
        public boolean isMatch(String ip) {
            int ippart = Integer.valueOf(ip);
            return this.begin <= ippart && ippart <= this.end;
        }
    }

    static class NumPattern
    implements IPPattern {
        int source;

        public NumPattern(String string) {
            this.source = Integer.valueOf(string);
        }

        @Override
        public boolean isMatch(String ip) {
            return this.source == Integer.valueOf(ip);
        }
    }

    static interface IPPattern {
        public boolean isMatch(String var1);
    }
}

