/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.net.io;

import com.meidusa.toolkit.net.io.AbstractPacketMetaData;
import com.meidusa.toolkit.net.io.PacketOutputStream;
import java.nio.ByteBuffer;

public class FramingOutputStream
extends PacketOutputStream {
    protected boolean packetwrittenWithHead;
    private AbstractPacketMetaData metaData;

    public FramingOutputStream(AbstractPacketMetaData metaData, boolean packetwrittenWithHead) {
        this.packetwrittenWithHead = packetwrittenWithHead;
        this.metaData = metaData;
        this._buffer.order(metaData.getByteOrder());
        this.resetPacket();
    }

    @Override
    public ByteBuffer returnPacketBuffer() {
        this._buffer.flip();
        if (!this.packetwrittenWithHead) {
            int count = this._buffer.limit() - this.metaData.getHeaderSize();
            this._buffer.putInt(count);
        }
        this._buffer.rewind();
        return this._buffer;
    }

    @Override
    public void initHeader() {
        if (!this.packetwrittenWithHead) {
            this.write(this.metaData.getHeadPad(), 0, this.metaData.getHeaderSize());
        }
    }
}

