/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.net;

import com.meidusa.toolkit.common.bean.util.Initialisable;
import com.meidusa.toolkit.common.bean.util.InitialisationException;
import com.meidusa.toolkit.net.AuthingableConnectionFactory;
import com.meidusa.toolkit.net.Connection;
import com.meidusa.toolkit.net.SocketChannelFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import org.apache.log4j.Logger;

public abstract class ClientNIOConnectionFactory
extends AuthingableConnectionFactory
implements Initialisable {
    private static Logger logger = Logger.getLogger(ClientNIOConnectionFactory.class);
    protected int port;
    protected String ipAddress;
    protected SocketChannelFactory socketChannelFactory;

    public SocketChannelFactory getSocketChannelFactory() {
        return this.socketChannelFactory;
    }

    public void setSocketChannelFactory(SocketChannelFactory socketChannelFactory) {
        this.socketChannelFactory = socketChannelFactory;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public void init() throws InitialisationException {
        this.setSocketChannelFactory(new SocketChannelFactory(){

            @Override
            public SocketChannel createSokectChannel() throws IOException {
                SocketChannel socketChannel = null;
                try {
                    socketChannel = ClientNIOConnectionFactory.this.ipAddress == null ? SocketChannel.open(new InetSocketAddress(ClientNIOConnectionFactory.this.port)) : SocketChannel.open(new InetSocketAddress(ClientNIOConnectionFactory.this.ipAddress, ClientNIOConnectionFactory.this.port));
                    socketChannel.configureBlocking(false);
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("open socket channel to server[" + ClientNIOConnectionFactory.this.ipAddress + ":" + ClientNIOConnectionFactory.this.port + "] success,local port=" + socketChannel.socket().getLocalPort()));
                    }
                }
                catch (IOException e) {
                    logger.error((Object)("could not connect to server[" + ClientNIOConnectionFactory.this.ipAddress + ":" + ClientNIOConnectionFactory.this.port + "]"), (Throwable)e);
                    throw e;
                }
                return socketChannel;
            }
        });
        if (this.getConnectionManager() == null) {
            throw new InitialisationException("connectionManager can not be null");
        }
    }

    @Override
    protected void initConnection(Connection connection) throws IOException {
        super.initConnection(connection);
        this.getConnectionManager().postRegisterNetEventHandler(connection, 1);
    }
}

