/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.net;

import com.meidusa.toolkit.net.Connection;
import com.meidusa.toolkit.net.ConnectionFactory;
import com.meidusa.toolkit.net.ConnectionManager;
import java.io.IOException;
import java.nio.channels.SocketChannel;

public abstract class AbstractConnectionFactory
implements ConnectionFactory {
    protected ConnectionManager connectionManager;
    private int sendBufferSize = 64;
    private int receiveBufferSize = 64;
    private boolean tcpNoDelay = true;
    private boolean keepAlive = true;

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public void setConnectionManager(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setSendBufferSize(int sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    @Override
    public Connection createConnection(SocketChannel channel, long createStamp) throws IOException {
        Connection connection = this.newConnectionInstance(channel, System.currentTimeMillis());
        this.initConnection(connection);
        return connection;
    }

    protected void initConnection(Connection connection) throws IOException {
        connection.getChannel().socket().setSendBufferSize(this.sendBufferSize * 1024);
        connection.getChannel().socket().setReceiveBufferSize(this.receiveBufferSize * 1024);
        connection.getChannel().socket().setTcpNoDelay(this.tcpNoDelay);
        connection.getChannel().socket().setKeepAlive(this.keepAlive);
    }

    protected abstract Connection newConnectionInstance(SocketChannel var1, long var2);
}

