package com.meidusa.toolkit.net;

import java.io.IOException;
import java.nio.channels.SocketChannel;


/**
 * ӹ, {@link #setConnectionManager(ConnectionManager)},
 * ConnectoinManager.
 * 
 * @author struct
 *
 */
public abstract class AbstractConnectionFactory implements ConnectionFactory {

	protected ConnectionManager connectionManager;
	
	private int sendBufferSize = 64;
	private int receiveBufferSize = 64;
	private boolean tcpNoDelay = true;
	private boolean keepAlive = true;
	
	public ConnectionManager getConnectionManager() {
		return connectionManager;
	}

	public void setConnectionManager(ConnectionManager connectionManager) {
		this.connectionManager = connectionManager;
	}

	
	public int getSendBufferSize() {
		return sendBufferSize;
	}

	public void setSendBufferSize(int sendBufferSize) {
		this.sendBufferSize = sendBufferSize;
	}

	public int getReceiveBufferSize() {
		return receiveBufferSize;
	}

	public void setReceiveBufferSize(int receiveBufferSize) {
		this.receiveBufferSize = receiveBufferSize;
	}

	public boolean isTcpNoDelay() {
		return tcpNoDelay;
	}

	public void setTcpNoDelay(boolean tcpNoDelay) {
		this.tcpNoDelay = tcpNoDelay;
	}

	public boolean isKeepAlive() {
		return keepAlive;
	}

	public void setKeepAlive(boolean keepAlive) {
		this.keepAlive = keepAlive;
	}
	
	/**
	 * һ,ʼ,עᵽӹ,
	 * 
	 * @return Connection ظʵ
	 */
	public Connection createConnection(SocketChannel channel, long createStamp) throws IOException {
		Connection connection = (Connection) newConnectionInstance(channel,System.currentTimeMillis());
		initConnection(connection);
		//connectionManager.postRegisterNetEventHandler(connection, SelectionKey.OP_READ);
		return connection;
	}
	
	/**
	 * Ժ,´һЩʼ
	 * @param connection
	 */
	protected void initConnection(Connection connection) throws IOException{
		connection.getChannel().socket().setSendBufferSize(sendBufferSize * 1024);
        connection.getChannel().socket().setReceiveBufferSize(receiveBufferSize * 1024);
        connection.getChannel().socket().setTcpNoDelay(tcpNoDelay);
        connection.getChannel().socket().setKeepAlive(keepAlive);
	}
	
	/**
	 * ʵ
	 * @param channel
	 * @param createStamp
	 * @return
	 */
	protected abstract Connection newConnectionInstance(SocketChannel channel, long createStamp);

}
