package com.meidusa.fastjson.parser.deserializer;

import java.lang.reflect.Type;
import java.util.Map;

import com.meidusa.fastjson.JSONException;
import com.meidusa.fastjson.parser.DefaultExtJSONParser;
import com.meidusa.fastjson.parser.DefaultJSONParser;
import com.meidusa.fastjson.parser.JSONScanner;
import com.meidusa.fastjson.parser.ParserConfig;
import com.meidusa.fastjson.util.FieldInfo;
import com.meidusa.fastjson.util.JavaBeanInfo;
import com.meidusa.fastjson.parser.Feature;

public abstract class ASMJavaBeanDeserializer implements ObjectDeserializer {

    protected InnerJavaBeanDeserializer serializer;

    public ASMJavaBeanDeserializer(ParserConfig mapping, Class<?> clazz){
        serializer = new InnerJavaBeanDeserializer(mapping, clazz,clazz);
    }

    public abstract Object createInstance(DefaultJSONParser parser, Type type);

    public InnerJavaBeanDeserializer getInnterSerializer() {
        return serializer;
    }

    @SuppressWarnings("unchecked")
    public <T> T deserialze(DefaultJSONParser parser, Type type,Object fieldName) {
        return (T) serializer.deserialze(parser, type,fieldName);
    }

    public int getFastMatchToken() {
        return serializer.getFastMatchToken();
    }

    public FieldDeserializer createFieldDeserializer(ParserConfig mapping,JavaBeanInfo beanInfo, FieldInfo fieldInfo) {
        return mapping.createFieldDeserializer(mapping, beanInfo, fieldInfo);
    }

    public boolean parseField(DefaultJSONParser parser, String key, Object object,Type objectType,
            Map<String, Object> fieldValues) {
        JSONScanner lexer = (JSONScanner) parser.getLexer(); // xxx

        FieldDeserializer fieldDeserializer = serializer.getFieldDeserializer(key);

        if (fieldDeserializer == null) {
            if (!parser.isEnabled(Feature.IgnoreNotMatch)) {
                throw new JSONException("setter not found, class " + serializer.getClass() + ", property " + key);
            }

            lexer.nextTokenWithColon();
            parser.parse(); // skip

            return false;
        }

        lexer.nextTokenWithColon(fieldDeserializer.getFastMatchToken());
        fieldDeserializer.parseField(parser, object,objectType,fieldValues);
        return true;
    }

    public final class InnerJavaBeanDeserializer extends JavaBeanDeserializer {

        private InnerJavaBeanDeserializer(ParserConfig mapping,  Class<?> clazz,Type type){
            super(mapping, clazz,type);
        }

        public boolean parseField(DefaultJSONParser parser, String key, Object object, Type objectType,
                Map<String, Object> fieldValues) {
            return ASMJavaBeanDeserializer.this.parseField(parser, key, object,objectType,fieldValues);
        }

       /* public FieldDeserializer createFieldDeserializer(ParserConfig mapping, //
                JavaBeanInfo beanInfo, //
                FieldInfo fieldInfo) {
            return ASMJavaBeanDeserializer.this.createFieldDeserializer(mapping, beanInfo, fieldInfo);
        }*/
    }

}
