/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.fastjson.util;

import java.lang.reflect.Method;

public class ASMUtils {
    public static boolean isAndroid(String vmName) {
        return "Dalvik".equals(vmName);
    }

    public static boolean isAndroid() {
        return ASMUtils.isAndroid(System.getProperty("java.vm.name"));
    }

    public static String getDesc(Method method) {
        StringBuffer buf = new StringBuffer();
        buf.append("(");
        Class<?>[] types = method.getParameterTypes();
        int i = 0;
        while (i < types.length) {
            buf.append(ASMUtils.getDesc(types[i]));
            ++i;
        }
        buf.append(")");
        buf.append(ASMUtils.getDesc(method.getReturnType()));
        return buf.toString();
    }

    public static String getDesc(Class<?> returnType) {
        if (returnType.isPrimitive()) {
            return ASMUtils.getPrimitiveLetter(returnType);
        }
        if (returnType.isArray()) {
            return "[" + ASMUtils.getDesc(returnType.getComponentType());
        }
        return "L" + ASMUtils.getType(returnType) + ";";
    }

    public static String getType(Class<?> parameterType) {
        if (parameterType.isArray()) {
            return "[" + ASMUtils.getDesc(parameterType.getComponentType());
        }
        if (!parameterType.isPrimitive()) {
            String clsName = parameterType.getCanonicalName();
            if (parameterType.isMemberClass()) {
                int lastDot = clsName.lastIndexOf(".");
                clsName = String.valueOf(clsName.substring(0, lastDot)) + "$" + clsName.substring(lastDot + 1);
            }
            return clsName.replaceAll("\\.", "/");
        }
        return ASMUtils.getPrimitiveLetter(parameterType);
    }

    public static String getPrimitiveLetter(Class<?> type) {
        if (Integer.TYPE.equals(type)) {
            return "I";
        }
        if (Void.TYPE.equals(type)) {
            return "V";
        }
        if (Boolean.TYPE.equals(type)) {
            return "Z";
        }
        if (Character.TYPE.equals(type)) {
            return "C";
        }
        if (Byte.TYPE.equals(type)) {
            return "B";
        }
        if (Short.TYPE.equals(type)) {
            return "S";
        }
        if (Float.TYPE.equals(type)) {
            return "F";
        }
        if (Long.TYPE.equals(type)) {
            return "J";
        }
        if (Double.TYPE.equals(type)) {
            return "D";
        }
        throw new IllegalStateException("Type: " + type.getCanonicalName() + " is not a primitive type");
    }
}

