/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.fastjson.parser.deserializer;

import com.meidusa.fastjson.JSONException;
import com.meidusa.fastjson.parser.DefaultExtJSONParser;
import com.meidusa.fastjson.parser.JSONLexer;
import com.meidusa.fastjson.parser.deserializer.ObjectDeserializer;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public class EnumDeserializer
implements ObjectDeserializer {
    private final Class<?> enumClass;
    private final Map<Integer, Enum> ordinalMap = new HashMap<Integer, Enum>();
    private final Map<String, Enum> nameMap = new HashMap<String, Enum>();

    public EnumDeserializer(Class<?> enumClass) {
        this.enumClass = enumClass;
        try {
            Object[] values;
            Method valueMethod = enumClass.getMethod("values", new Class[0]);
            Object[] objectArray = values = (Object[])valueMethod.invoke(null, new Object[0]);
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                Object value = objectArray[n2];
                Enum e = (Enum)value;
                this.ordinalMap.put(e.ordinal(), e);
                this.nameMap.put(e.name(), e);
                ++n2;
            }
        }
        catch (Exception ex) {
            throw new JSONException("init enum values error, " + enumClass.getName());
        }
    }

    @Override
    public <T> T deserialze(DefaultExtJSONParser parser, Type type) {
        block8: {
            JSONLexer lexer = parser.getLexer();
            if (lexer.token() == 2) {
                Integer value = lexer.intValue();
                lexer.nextToken(16);
                Enum e = this.ordinalMap.get(value);
                if (e == null) {
                    throw new JSONException("parse enum " + this.enumClass.getName() + " error, value : " + value);
                }
                return (T)e;
            }
            if (lexer.token() == 4) {
                String strVal = lexer.stringVal();
                lexer.nextToken(16);
                if (strVal.length() == 0) {
                    return null;
                }
                Enum value = this.nameMap.get(strVal);
                return (T)Enum.valueOf(this.enumClass, strVal);
            }
            if (lexer.token() != 8) break block8;
            Object value = null;
            lexer.nextToken(16);
            return null;
        }
        try {
            Object value = parser.parse();
            throw new JSONException("parse enum " + this.enumClass.getName() + " error, value : " + value);
        }
        catch (JSONException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new JSONException(e.getMessage(), e);
        }
    }

    @Override
    public int getFastMatchToken() {
        return 2;
    }
}

