/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.fastjson.parser.deserializer;

import com.meidusa.fastjson.JSONArray;
import com.meidusa.fastjson.parser.DefaultExtJSONParser;
import com.meidusa.fastjson.parser.deserializer.ObjectDeserializer;
import com.meidusa.fastjson.util.TypeUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Type;

public class ArrayDeserializer
implements ObjectDeserializer {
    public static final ArrayDeserializer instance = new ArrayDeserializer();

    @Override
    public <T> T deserialze(DefaultExtJSONParser parser, Type clazz) {
        if (parser.getLexer().token() == 8) {
            parser.getLexer().nextToken(16);
            return null;
        }
        JSONArray array = new JSONArray();
        parser.parseArray(array, clazz);
        return ArrayDeserializer.toObjectArray(parser, (Class)clazz, array);
    }

    public static <T> T toObjectArray(DefaultExtJSONParser parser, Class<T> clazz, JSONArray array) {
        int size = array.size();
        Class<?> componentType = clazz.getComponentType();
        Object objArray = Array.newInstance(componentType, size);
        int i = 0;
        while (i < size) {
            Object element;
            Object value = array.get(i);
            if (componentType.isArray()) {
                element = ArrayDeserializer.toObjectArray(parser, componentType, (JSONArray)value);
                Array.set(objArray, i, element);
            } else {
                element = TypeUtils.cast(value, componentType, parser.getConfig());
                Array.set(objArray, i, element);
            }
            ++i;
        }
        return (T)objArray;
    }

    @Override
    public int getFastMatchToken() {
        return 14;
    }
}

