/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.fastjson;

import com.meidusa.fastjson.JSONArray;
import com.meidusa.fastjson.JSONAware;
import com.meidusa.fastjson.JSONException;
import com.meidusa.fastjson.JSONObject;
import com.meidusa.fastjson.JSONStreamAware;
import com.meidusa.fastjson.TypeReference;
import com.meidusa.fastjson.parser.DefaultExtJSONParser;
import com.meidusa.fastjson.parser.ParserConfig;
import com.meidusa.fastjson.serializer.JSONSerializer;
import com.meidusa.fastjson.serializer.JavaBeanSerializer;
import com.meidusa.fastjson.serializer.SerializeConfig;
import com.meidusa.fastjson.serializer.SerializeWriter;
import com.meidusa.fastjson.util.FieldInfo;
import com.meidusa.fastjson.util.IOUtils;
import com.meidusa.fastjson.util.ThreadLocalCache;
import com.meidusa.fastjson.util.TypeUtils;
import com.meidusa.fastjson.util.UTF8Decoder;
import com.meidusa.fastmark.feature.Feature;
import com.meidusa.fastmark.feature.SerializerFeature;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public abstract class JSON
implements JSONStreamAware,
JSONAware {
    public static final int DEFAULT_PARSER_FEATURE;
    public static final int DEFAULT_GENERATE_FEATURE;
    public static CharsetDecoder UTF8_CharsetEncoder;

    static {
        int features = 0;
        features |= Feature.AutoCloseSource.getMask();
        features |= Feature.InternFieldNames.getMask();
        features |= Feature.UseBigDecimal.getMask();
        features |= Feature.AllowUnQuotedFieldNames.getMask();
        features |= Feature.AllowSingleQuotes.getMask();
        features |= Feature.AllowArbitraryCommas.getMask();
        features |= Feature.SortFeidFastMatch.getMask();
        DEFAULT_PARSER_FEATURE = features |= Feature.IgnoreNotMatch.getMask();
        features = 0;
        features |= SerializerFeature.QuoteFieldNames.getMask();
        features |= SerializerFeature.SkipTransientField.getMask();
        features |= SerializerFeature.SortField.getMask();
        DEFAULT_GENERATE_FEATURE = features |= SerializerFeature.WriteEnumUsingToString.getMask();
        UTF8_CharsetEncoder = new UTF8Decoder();
    }

    public static final Object parse(String text) {
        return JSON.parse(text, DEFAULT_PARSER_FEATURE);
    }

    public static final Object parse(String text, int features) {
        if (text == null) {
            return null;
        }
        DefaultExtJSONParser parser = new DefaultExtJSONParser(text, ParserConfig.getGlobalInstance(), features);
        Object value = parser.parse();
        parser.close();
        return value;
    }

    public static final Object parse(byte[] input, Feature ... features) {
        return JSON.parse(input, 0, input.length, UTF8_CharsetEncoder, features);
    }

    public static final Object parse(byte[] input, int off, int len, CharsetDecoder charsetDecoder, Feature ... features) {
        if (input == null || input.length == 0) {
            return null;
        }
        int featureValues = DEFAULT_PARSER_FEATURE;
        Feature[] featureArray = features;
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            Feature featrue = featureArray[n2];
            featureValues = Feature.config((int)featureValues, (Feature)featrue, (boolean)true);
            ++n2;
        }
        return JSON.parse(input, off, len, charsetDecoder, featureValues);
    }

    public static final Object parse(byte[] input, int off, int len, CharsetDecoder charsetDecoder, int features) {
        charsetDecoder.reset();
        int scaleLength = (int)((double)len * (double)charsetDecoder.maxCharsPerByte());
        char[] chars = ThreadLocalCache.getChars(scaleLength);
        ByteBuffer byteBuf = ByteBuffer.wrap(input, off, len);
        CharBuffer charBuf = CharBuffer.wrap(chars);
        IOUtils.decode(charsetDecoder, byteBuf, charBuf);
        int position = charBuf.position();
        DefaultExtJSONParser parser = new DefaultExtJSONParser(chars, position, ParserConfig.getGlobalInstance(), features);
        Object value = parser.parse();
        parser.close();
        return value;
    }

    public static final Object parse(String text, Feature ... features) {
        int featureValues = DEFAULT_PARSER_FEATURE;
        Feature[] featureArray = features;
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            Feature featrue = featureArray[n2];
            featureValues = Feature.config((int)featureValues, (Feature)featrue, (boolean)true);
            ++n2;
        }
        return JSON.parse(text, featureValues);
    }

    public static final JSONObject parseObject(String text, Feature ... features) {
        return (JSONObject)JSON.parse(text, features);
    }

    public static final JSONObject parseObject(String text) {
        return (JSONObject)JSON.parse(text);
    }

    public static final <T> T parseObject(String text, TypeReference<T> type, Feature ... features) {
        return JSON.parseObject(text, type.getType(), ParserConfig.getGlobalInstance(), DEFAULT_PARSER_FEATURE, features);
    }

    public static final <T> T parseObject(String text, Class<T> clazz, Feature ... features) {
        return JSON.parseObject(text, clazz, ParserConfig.getGlobalInstance(), DEFAULT_PARSER_FEATURE, features);
    }

    public static final <T> T parseObject(String input, Type clazz, Feature ... features) {
        return JSON.parseObject(input, clazz, ParserConfig.getGlobalInstance(), DEFAULT_PARSER_FEATURE, features);
    }

    public static final <T> T parseObject(String input, Type clazz, int featureValues, Feature ... features) {
        if (input == null) {
            return null;
        }
        Feature[] featureArray = features;
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            Feature featrue = featureArray[n2];
            featureValues = Feature.config((int)featureValues, (Feature)featrue, (boolean)true);
            ++n2;
        }
        DefaultExtJSONParser parser = new DefaultExtJSONParser(input, ParserConfig.getGlobalInstance(), featureValues);
        Object value = parser.parseObject(clazz);
        parser.close();
        return value;
    }

    public static final <T> T parseObject(String input, Type clazz, ParserConfig config, int featureValues, Feature ... features) {
        if (input == null) {
            return null;
        }
        Feature[] featureArray = features;
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            Feature featrue = featureArray[n2];
            featureValues = Feature.config((int)featureValues, (Feature)featrue, (boolean)true);
            ++n2;
        }
        DefaultExtJSONParser parser = new DefaultExtJSONParser(input, config, featureValues);
        Object value = parser.parseObject(clazz);
        if (clazz != JSONArray.class) {
            parser.close();
        }
        return value;
    }

    public static final <T> T parseObject(byte[] input, Type clazz, Feature ... features) {
        return JSON.parseObject(input, 0, input.length, UTF8_CharsetEncoder, clazz, features);
    }

    public static final <T> T parseObject(byte[] input, int off, int len, CharsetDecoder charsetDecoder, Type clazz, Feature ... features) {
        charsetDecoder.reset();
        int scaleLength = (int)((double)len * (double)charsetDecoder.maxCharsPerByte());
        char[] chars = ThreadLocalCache.getChars(scaleLength);
        ByteBuffer byteBuf = ByteBuffer.wrap(input, off, len);
        CharBuffer charByte = CharBuffer.wrap(chars);
        IOUtils.decode(charsetDecoder, byteBuf, charByte);
        int position = charByte.position();
        return JSON.parseObject(chars, position, clazz, features);
    }

    public static final <T> T parseObject(char[] input, int length, Type clazz, Feature ... features) {
        if (input == null || input.length == 0) {
            return null;
        }
        int featureValues = DEFAULT_PARSER_FEATURE;
        Feature[] featureArray = features;
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            Feature featrue = featureArray[n2];
            featureValues = Feature.config((int)featureValues, (Feature)featrue, (boolean)true);
            ++n2;
        }
        DefaultExtJSONParser parser = new DefaultExtJSONParser(input, length, ParserConfig.getGlobalInstance(), featureValues);
        Object value = parser.parseObject(clazz);
        parser.close();
        return value;
    }

    public static final <T> T parseObject(String text, Class<T> clazz) {
        return JSON.parseObject(text, clazz, new Feature[0]);
    }

    public static final JSONArray parseArray(String text) {
        return (JSONArray)JSON.parse(text);
    }

    public static final <T> List<T> parseArray(String text, Class<T> clazz) {
        if (text == null) {
            return null;
        }
        ArrayList list = new ArrayList();
        DefaultExtJSONParser parser = new DefaultExtJSONParser(text, ParserConfig.getGlobalInstance());
        parser.parseArray(clazz, list);
        parser.close();
        return list;
    }

    public static final List<Object> parseArray(String text, Type[] types) {
        if (text == null) {
            return null;
        }
        DefaultExtJSONParser parser = new DefaultExtJSONParser(text, ParserConfig.getGlobalInstance());
        List<Object> list = Arrays.asList(parser.parseArray(types));
        parser.close();
        return list;
    }

    public static final String toJSONString(Object object) {
        return JSON.toJSONString(object, new SerializerFeature[0]);
    }

    public static final String toJSONString(Object object, SerializerFeature ... features) {
        SerializeWriter out = new SerializeWriter();
        try {
            JSONSerializer serializer = new JSONSerializer(out);
            SerializerFeature[] serializerFeatureArray = features;
            int n = features.length;
            int n2 = 0;
            while (n2 < n) {
                SerializerFeature feature = serializerFeatureArray[n2];
                serializer.config(feature, true);
                ++n2;
            }
            serializer.write(object);
            String string = out.toString();
            return string;
        }
        catch (StackOverflowError e) {
            throw new JSONException("maybe circular references", e);
        }
        finally {
            out.close();
        }
    }

    public static final String toJSONString(Object object, SerializeConfig config, SerializerFeature ... features) {
        SerializeWriter out = new SerializeWriter();
        try {
            JSONSerializer serializer = new JSONSerializer(out, config);
            SerializerFeature[] serializerFeatureArray = features;
            int n = features.length;
            int n2 = 0;
            while (n2 < n) {
                SerializerFeature feature = serializerFeatureArray[n2];
                serializer.config(feature, true);
                ++n2;
            }
            serializer.write(object);
            String string = out.toString();
            return string;
        }
        catch (StackOverflowError e) {
            throw new JSONException("maybe circular references", e);
        }
        finally {
            out.close();
        }
    }

    public static final String toJSONStringZ(Object object, SerializeConfig mapping, SerializerFeature ... features) {
        SerializeWriter out = new SerializeWriter(features);
        try {
            JSONSerializer serializer = new JSONSerializer(out, mapping);
            serializer.write(object);
            String string = out.toString();
            return string;
        }
        catch (StackOverflowError e) {
            throw new JSONException("maybe circular references", e);
        }
        finally {
            out.close();
        }
    }

    public static final String toJSONString(Object object, boolean prettyFormat) {
        if (!prettyFormat) {
            return JSON.toJSONString(object);
        }
        return JSON.toJSONString(object, SerializerFeature.PrettyFormat);
    }

    public String toString() {
        return this.toJSONString();
    }

    @Override
    public String toJSONString() {
        SerializeWriter out = new SerializeWriter();
        try {
            new JSONSerializer(out).write(this);
            String string = out.toString();
            return string;
        }
        finally {
            out.close();
        }
    }

    @Override
    public void writeJSONString(Appendable appendable) {
        SerializeWriter out = new SerializeWriter();
        try {
            try {
                new JSONSerializer(out).write(this);
                appendable.append(out.toString());
            }
            catch (IOException e) {
                throw new JSONException(e.getMessage(), e);
            }
        }
        finally {
            out.close();
        }
    }

    public static final Object toJSON(Object javaObject) {
        return JSON.toJSON(javaObject, ParserConfig.getGlobalInstance());
    }

    public static final Object toJSON(Object javaObject, ParserConfig mapping) {
        if (javaObject == null) {
            return null;
        }
        if (javaObject instanceof JSON) {
            return (JSON)javaObject;
        }
        if (javaObject instanceof Map) {
            Map map = (Map)javaObject;
            JSONObject json = new JSONObject(map.size());
            for (Map.Entry entry : map.entrySet()) {
                Object jsonValue = JSON.toJSON(entry.getValue());
                json.put((String)entry.getKey(), jsonValue);
            }
            return json;
        }
        if (javaObject instanceof Collection) {
            Collection collection = (Collection)javaObject;
            JSONArray<Object> array = new JSONArray<Object>(collection.size());
            for (Object item : collection) {
                Object jsonValue = JSON.toJSON(item);
                array.add(jsonValue);
            }
            return array;
        }
        Class<?> clazz = javaObject.getClass();
        if (clazz.isArray()) {
            int len = Array.getLength(javaObject);
            JSONArray<Object> array = new JSONArray<Object>(len);
            int i = 0;
            while (i < len) {
                Object item = Array.get(javaObject, i);
                Object jsonValue = JSON.toJSON(item);
                array.add(jsonValue);
                ++i;
            }
            return array;
        }
        if (mapping.isPrimitive(clazz)) {
            return javaObject;
        }
        try {
            List<FieldInfo> getters = JavaBeanSerializer.computeGetters(clazz, null);
            JSONObject json = new JSONObject(getters.size());
            for (FieldInfo field : getters) {
                Method method = field.getMethod();
                Object value = method.invoke(javaObject, new Object[0]);
                Object jsonValue = JSON.toJSON(value);
                json.put(field.getName(), jsonValue);
            }
            return json;
        }
        catch (Exception e) {
            throw new JSONException("toJSON error", e);
        }
    }

    public static final <T> T toJavaObject(JSON json, Class<T> clazz) {
        return TypeUtils.cast((Object)json, clazz, ParserConfig.getGlobalInstance());
    }
}

