package com.meidusa.fastjson.parser.deserializer;

import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import com.meidusa.fastjson.JSONException;
import com.meidusa.fastjson.parser.DefaultExtJSONParser;
import com.meidusa.fastjson.parser.JSONToken;
import com.meidusa.toolkit.common.bean.PureJavaReflectionProvider;

public class CollectionDeserializer implements ObjectDeserializer {

    public final static CollectionDeserializer instance = new CollectionDeserializer();

    @SuppressWarnings({ "unchecked", "rawtypes" })
    public <T> T deserialze(DefaultExtJSONParser parser, Type type) {
        if (parser.getLexer().token() == JSONToken.NULL) {
            parser.getLexer().nextToken(JSONToken.COMMA);
            return null;
        }

        Collection list = null;
        if (type instanceof Class<?>) {
            Class<?> clazz = (Class<?>) type;
            
            int modifiers = clazz.getModifiers() ;
            if( (modifiers & Modifier.ABSTRACT) != 0  || (modifiers & Modifier.INTERFACE) != 0){
                
            	if (Set.class.isAssignableFrom(clazz)) {
                    list = new HashSet();
                } else if (List.class.isAssignableFrom(clazz)) {
                    list = new ArrayList();
                } else {
                	list = new ArrayList();
                }
            }else{
                list = (Collection)PureJavaReflectionProvider.getInstance().newInstance(clazz);
            }
            
            
        }else if(type instanceof ParameterizedType){
            ParameterizedType clazz = (ParameterizedType) type;
            Type rawType = clazz.getRawType();
            if(rawType instanceof Class<?>){
                int modifiers = ((Class) rawType).getModifiers() ;
                if( (modifiers & Modifier.ABSTRACT) != 0  || (modifiers & Modifier.INTERFACE) != 0){
                	if (Set.class.isAssignableFrom((Class)rawType)) {
                        list = new HashSet();
                    } else if (List.class.isAssignableFrom((Class)rawType)) {
                        list = new ArrayList();
                    } else {
                    	list = new ArrayList();
                    }
                }else{
                    list = (Collection)PureJavaReflectionProvider.getInstance().newInstance((Class)rawType);
                }
            }
           
        }
        
        if (list == null) {
            list = new ArrayList();
        }

        Type itemType;
        if (type instanceof ParameterizedType) {
            itemType = ((ParameterizedType) type).getActualTypeArguments()[0];
        } else {
            itemType = Object.class;
        }
        parser.parseArray(itemType, list);

        return (T) list;
    }

    public int getFastMatchToken() {
        return JSONToken.LBRACKET;
    }
}
