package com.meidusa.fastjson.parser.deserializer;

import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

import com.meidusa.fastjson.parser.DefaultExtJSONParser;
import com.meidusa.fastjson.parser.JSONToken;
import com.meidusa.toolkit.common.bean.PureJavaReflectionProvider;
import com.meidusa.toolkit.common.bean.ReflectionProvider;

public class ArrayListTypeDeserializer implements ObjectDeserializer {
    private static ReflectionProvider provider = PureJavaReflectionProvider.getInstance();
    private Type itemType;

    public ArrayListTypeDeserializer(Type type){
        this.itemType = type;
    }

    @SuppressWarnings({ "unchecked", "rawtypes" })
    public <T> T deserialze(DefaultExtJSONParser parser, Type type) {
        List list = null;
        if(type instanceof Class){
            Class clazz = (Class) type;
            int modifiers = clazz.getModifiers() ;
            if( (modifiers & Modifier.ABSTRACT) != 0  || (clazz.getModifiers() & Modifier.INTERFACE) != 0){
                list = new ArrayList();
            }else{
                list = (List)provider.newInstance(clazz);
            }
        }else{
            list = new ArrayList();
        }
        
        parser.parseArray(itemType, list);

        return (T) list;
    }

    public int getFastMatchToken() {
        return JSONToken.LBRACKET;
    }

}
