package com.meidusa.fastjson.type;

import java.awt.List;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Map;
import java.util.Set;

/**
 * @author daisy
 * 
 */
public class DefinedParameterizedTypeBuilder {

	public static Type buildDefinedType(Type type, Map<TypeVariable<?>, Type> typeMap) {
		if (type instanceof ParameterizedType) {
			ParameterizedType castType = (ParameterizedType) type;
			DefinedParameterizedType definedParameterizedType = new DefinedParameterizedType();
			definedParameterizedType.setRawType((Class<?>) castType.getRawType());
			definedParameterizedType.setOwnerType(castType.getOwnerType());

			Type[] actualTypes = castType.getActualTypeArguments();
			Type[] actualDefinedTypes = new Type[actualTypes.length];
			for (int i = 0; i < actualTypes.length; i++) {
				if (actualTypes[i] instanceof Class<?>) {
					actualDefinedTypes[i] = actualTypes[i];
				} else if (actualTypes[i] instanceof TypeVariable<?>) {
					actualDefinedTypes[i] = typeMap.get(actualTypes[i]);
					if (actualDefinedTypes[i] == null) {
						// check bounds
						Type[] bounds = ((TypeVariable<?>) actualTypes[i]).getBounds();
						Type[] organizedBounds = new Type[bounds.length];
						// check if class among these bounds
						for (int j = 0; j < bounds.length; j++) {
							organizedBounds[i] = buildDefinedType(bounds[0], typeMap);
						}
						actualDefinedTypes[i] = chooseFromBounds(organizedBounds);
						actualDefinedTypes[i] = buildDefinedType(actualDefinedTypes[i], typeMap);
					}
				} else if (actualTypes[i] instanceof WildcardType) {
					actualDefinedTypes[i] = chooseFromBounds(((WildcardType) actualTypes[i]).getUpperBounds());
					actualDefinedTypes[i] = buildDefinedType(actualDefinedTypes[i], typeMap);
				} else if (actualTypes[i] instanceof ParameterizedType) {
					actualDefinedTypes[i] = buildDefinedType(actualTypes[i], typeMap);
				}
			}
			definedParameterizedType.setActualTypes(actualDefinedTypes);
			return definedParameterizedType;
		} else if (type instanceof Class<?>) {
			return type;
		} else if (type instanceof TypeVariable<?>) {
			return typeMap.get(type);
		} else if (type instanceof WildcardType) {
			return chooseFromBounds(((WildcardType) type).getUpperBounds());
		} else {
			return null;
		}
	}

	public static Type chooseFromBounds(Type[] types) {
		for (int i = 0; i < types.length; i++) {
			Class<?> typeRawClass = null;
			if (types[i] instanceof ParameterizedType) {
				typeRawClass = (Class<?>) ((ParameterizedType) types[i]).getRawType();
			} else if (types[i] instanceof Class<?>) {
				typeRawClass = (Class<?>) types[i];
			}
			if (typeRawClass != null) {
				if (!typeRawClass.isInterface()) {
					return types[i];
				} else if (typeRawClass == List.class || typeRawClass == Map.class || typeRawClass == Set.class) {
					return types[i];
				}
			}
		}
		return Object.class;
	}

	public static void buildTypeVariableMap(Type type, Map<TypeVariable<?>, Type> map) {
		Class<?> rawType = null;
		if (type instanceof ParameterizedType) {
			Type[] actualArguments = ((ParameterizedType) type).getActualTypeArguments();
			Type[] organizedArguments = new Type[actualArguments.length];
			for (int i = 0; i < actualArguments.length; i++) {
				organizedArguments[i] = buildDefinedType(actualArguments[i], map);
			}
			rawType = (Class<?>) ((ParameterizedType) type).getRawType();
			TypeVariable<?>[] variables = rawType.getTypeParameters();
			for (int i = 0; i < actualArguments.length; i++) {
				map.put(variables[i], organizedArguments[i]);
			}
		} else if (type instanceof Class<?>) {
			rawType = (Class<?>) type;
		}
		Type[] interfaces = rawType.getGenericInterfaces();
		Type superClass = rawType.getGenericSuperclass();
		for (int i = 0; i < interfaces.length; i++) {
			buildTypeVariableMap(interfaces[i], map);
		}
		if (superClass != null && superClass != Object.class) {
			buildTypeVariableMap(superClass, map);
		}
	}

}
