package com.meidusa.fastjson.parser.deserializer;

import java.lang.reflect.Type;

import com.meidusa.fastjson.parser.DefaultExtJSONParser;
import com.meidusa.fastjson.parser.JSONToken;
import com.meidusa.fastjson.parser.ParserConfig;
import com.meidusa.fastjson.util.TypeUtils;

public class ThrowableDeserializer extends JavaBeanDeserializer {

    public ThrowableDeserializer(ParserConfig mapping, Class<?> clazz){
        super(mapping, clazz);
    }

    @SuppressWarnings("unchecked")
    public <T> T deserialze(DefaultExtJSONParser parser, Type clazz) {
        Object jsonValue = parser.parse();
        return (T) TypeUtils.cast(jsonValue, clazz, parser.getConfig());
    }

    public int getFastMatchToken() {
        return JSONToken.LBRACE;
    }
}
