/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.fastbson.parse;

import com.meidusa.fastbson.FastBsonSerializer;
import com.meidusa.fastbson.exception.SerializeException;
import com.meidusa.fastbson.parse.BSONScanner;
import com.meidusa.fastbson.util.ObjectId;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.Date;

public class ByteArrayBSONScanner
implements BSONScanner {
    public static String CHARSET = "UTF-8";
    private int position = 0;
    private byte[] bsonPacket;
    private byte currentType = 0;

    public ByteArrayBSONScanner(byte[] bsonPacket) {
        this.bsonPacket = bsonPacket;
    }

    public ByteArrayBSONScanner(byte[] bsonPacket, int position) {
        this.bsonPacket = bsonPacket;
        this.position = position;
    }

    @Override
    public byte getCurrentType() {
        if (this.position == 0) {
            return 3;
        }
        return this.currentType;
    }

    @Override
    public void reset() {
        this.position = 0;
    }

    @Override
    public void skip(int skipNum) {
        this.position += skipNum;
    }

    @Override
    public void skipField() {
        byte type = this.readType();
        this.readCString();
        switch (type) {
            case 1: {
                this.skip(8);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.skip(this.readInt());
                break;
            }
            case 10: {
                break;
            }
            case 126: {
                this.skip(this.readInt() + 4);
                break;
            }
            case 16: {
                this.skip(4);
                break;
            }
            case 18: {
                this.skip(8);
                break;
            }
            case 8: {
                this.skip(1);
                break;
            }
            case 7: {
                this.skip(24);
                break;
            }
            case 17: {
                this.skip(8);
                break;
            }
        }
    }

    @Override
    public byte readType() {
        this.currentType = this.bsonPacket[this.position++];
        return this.currentType;
    }

    @Override
    public byte readBSONByte() {
        return (byte)this.readBSONInt();
    }

    @Override
    public int readBSONInt() {
        switch (this.currentType) {
            case 16: {
                return this.readInt();
            }
            case 18: {
                return (int)this.readLong();
            }
            case 1: {
                return (int)this.readDouble();
            }
            case 126: {
                return this.readBigDecimal().intValue();
            }
            case 2: {
                return Integer.valueOf(this.readString());
            }
            case 10: {
                return 0;
            }
        }
        throw new SerializeException.ErrorPacketException("not correct type for int");
    }

    @Override
    public int readInt() {
        int x = 0;
        x |= (0xFF & this.bsonPacket[this.position++]) << 0;
        x |= (0xFF & this.bsonPacket[this.position++]) << 8;
        x |= (0xFF & this.bsonPacket[this.position++]) << 16;
        return x |= (0xFF & this.bsonPacket[this.position++]) << 24;
    }

    @Override
    public long readBSONLong() {
        switch (this.currentType) {
            case 16: {
                return this.readInt();
            }
            case 18: {
                return this.readLong();
            }
            case 1: {
                return (long)this.readDouble();
            }
            case 126: {
                return this.readBigDecimal().longValue();
            }
            case 2: {
                return Long.valueOf(this.readString());
            }
            case 10: {
                return 0L;
            }
        }
        throw new SerializeException.ErrorPacketException("not correct type for long");
    }

    @Override
    public long readLong() {
        long x = 0L;
        x |= (0xFFL & (long)this.bsonPacket[this.position++]) << 0;
        x |= (0xFFL & (long)this.bsonPacket[this.position++]) << 8;
        x |= (0xFFL & (long)this.bsonPacket[this.position++]) << 16;
        x |= (0xFFL & (long)this.bsonPacket[this.position++]) << 24;
        x |= (0xFFL & (long)this.bsonPacket[this.position++]) << 32;
        x |= (0xFFL & (long)this.bsonPacket[this.position++]) << 40;
        x |= (0xFFL & (long)this.bsonPacket[this.position++]) << 48;
        return x |= (0xFFL & (long)this.bsonPacket[this.position++]) << 56;
    }

    @Override
    public boolean readBSONBoolean() {
        switch (this.currentType) {
            case 16: {
                return this.readInt() > 0;
            }
            case 18: {
                return this.readLong() > 0L;
            }
            case 1: {
                return this.readDouble() > 0.0;
            }
            case 126: {
                return this.readBigDecimal().doubleValue() != 0.0;
            }
            case 2: {
                return this.readString().toLowerCase().equals("true");
            }
            case 10: {
                return false;
            }
            case 8: {
                return this.readBoolean();
            }
        }
        throw new SerializeException.ErrorPacketException("not correct type for bool");
    }

    @Override
    public boolean readBoolean() {
        return this.bsonPacket[this.position++] > 0;
    }

    @Override
    public Date readBSONDate() {
        switch (this.currentType) {
            case 18: {
                return new Date(this.readLong());
            }
            case 10: {
                return null;
            }
            case 9: {
                return this.readDate();
            }
            case 2: {
                try {
                    return FastBsonSerializer.dateFormat.parse(this.readString());
                }
                catch (ParseException e) {
                    throw new SerializeException.ErrorPacketException("wrong date format");
                }
            }
        }
        throw new SerializeException.ErrorPacketException("not correct type for date");
    }

    @Override
    public Date readDate() {
        return new Date(this.readLong());
    }

    @Override
    public ObjectId readBSONOid() {
        byte[] oid = new byte[12];
        System.arraycopy(this.bsonPacket, this.position, oid, 0, 12);
        this.position += 12;
        return new ObjectId(oid);
    }

    @Override
    public String readBSONString() {
        switch (this.currentType) {
            case 16: {
                return String.valueOf(this.readInt());
            }
            case 18: {
                return String.valueOf(this.readLong());
            }
            case 1: {
                return String.valueOf(this.readDouble());
            }
            case 126: {
                return String.valueOf(this.readBigDecimal());
            }
            case 2: {
                return this.readString();
            }
            case 10: {
                return null;
            }
            case 8: {
                return String.valueOf(this.readBoolean());
            }
            case 9: {
                return FastBsonSerializer.dateFormat.format(this.readDate());
            }
        }
        throw new SerializeException.ErrorPacketException("not correct type for string");
    }

    @Override
    public String readString() {
        String returnStr = null;
        int strLength = this.readInt();
        if (strLength < 0 || strLength > 0x300000) {
            throw new RuntimeException("bad string size: " + strLength);
        }
        try {
            returnStr = new String(this.bsonPacket, this.position, strLength - 1, CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new SerializeException.EncodingException("can't encode string", e);
        }
        this.position += strLength;
        return returnStr;
    }

    @Override
    public String readCString() {
        String returnStr = null;
        int begin = this.position;
        while (this.position < this.bsonPacket.length) {
            if (this.bsonPacket[this.position++] == 0) break;
        }
        int length = this.position - begin - 1;
        try {
            returnStr = new String(this.bsonPacket, begin, length, CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new SerializeException.EncodingException("can't encode string", e);
        }
        return returnStr;
    }

    @Override
    public double readBSONDouble() {
        switch (this.currentType) {
            case 126: {
                return this.readBigDecimal().doubleValue();
            }
            case 1: {
                return this.readDouble();
            }
            case 16: {
                return this.readInt();
            }
            case 18: {
                return this.readLong();
            }
            case 10: {
                return 0.0;
            }
            case 2: {
                return Double.valueOf(this.readString());
            }
        }
        throw new SerializeException.ErrorPacketException("not correct type for double");
    }

    @Override
    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public BigDecimal readBSONBigDecimal() {
        switch (this.currentType) {
            case 126: {
                return this.readBigDecimal();
            }
            case 1: {
                return new BigDecimal(this.readDouble());
            }
            case 16: {
                return new BigDecimal(this.readInt());
            }
            case 18: {
                return new BigDecimal(this.readLong());
            }
            case 10: {
                return new BigDecimal(0);
            }
            case 2: {
                return new BigDecimal(this.readString());
            }
        }
        throw new SerializeException.ErrorPacketException("not correct type for double");
    }

    @Override
    public BigDecimal readBigDecimal() {
        int size = this.readInt();
        byte[] bts = new byte[size];
        System.arraycopy(this.bsonPacket, this.position, bts, 0, size);
        this.position += size;
        int scale = this.readInt();
        return new BigDecimal(new BigInteger(bts), scale);
    }

    @Override
    public boolean hasRemaining() {
        return this.position < this.bsonPacket.length;
    }

    @Override
    public byte[] readBSONBinary() {
        int size = this.readInt();
        this.skip(1);
        byte[] bts = new byte[size];
        System.arraycopy(this.bsonPacket, this.position, bts, 0, size);
        this.position += size;
        return bts;
    }

    @Override
    public boolean match(byte[] given) {
        int i = 0;
        while (i < given.length) {
            try {
                if (given[i] != this.bsonPacket[this.position + i]) {
                    return false;
                }
            }
            catch (Exception e) {
                return false;
            }
            ++i;
        }
        this.position += given.length;
        return true;
    }

    public byte[] getBsonPacket() {
        return this.bsonPacket;
    }

    public void setBsonPacket(byte[] bsonPacket) {
        this.bsonPacket = bsonPacket;
    }
}

