package com.meidusa.toolkit.common.util.regex;

import java.text.MessageFormat;

import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.Perl5Compiler;

/**
 * һָʽpatternתPerl5׼ʽı.
 *
 * @version 
 * 
 */
public abstract class Perl5CompilerWrapper implements PatternCompiler {
    /** Ĭϵλ־ */
    public static final int DEFAULT_MASK = 0;

    /** Сдб־ */
    public static final int CASE_INSENSITIVE_MASK = 0x1000;

    /** ֻpattern־ */
    public static final int READ_ONLY_MASK = 0x2000;

    /** Escapeַ */
    protected static final char ESCAPE_CHAR = '\\';

    /** Perl5ʽıַ */
    private static final String PERL5_META_CHARS = "*?+[]()|^$.{}\\";

    // Ϣ
    private static final String ERROR_UNEXPECTED_CHAR = "Unexpected \"{0}\" near \"{1}\"";

    /** ڲperl5 */
    protected final Perl5Compiler compiler = new Perl5Compiler();

    /**
     * patternperl5ʽ.
     *
     * @param pattern  Ҫpattern
     *
     * @return Perl5ʽ
     *
     * @throws MalformedPatternException  patternʽȷ
     */
    public Pattern compile(String pattern) throws MalformedPatternException {
        return compile(pattern.toCharArray(), DEFAULT_MASK);
    }

    /**
     * patternperl5ʽ.
     *
     * @param pattern  Ҫpattern
     * @param options  λ־
     *
     * @return Perl5ʽ
     *
     * @throws MalformedPatternException  patternʽȷ
     */
    public Pattern compile(String pattern, int options) throws MalformedPatternException {
        return compile(pattern.toCharArray(), options);
    }

    /**
     * patternperl5ʽ.
     *
     * @param pattern  Ҫpattern
     *
     * @return Perl5ʽ
     *
     * @throws MalformedPatternException  patternʽȷ
     */
    public Pattern compile(char[] pattern) throws MalformedPatternException {
        return compile(pattern, DEFAULT_MASK);
    }

    /**
     * patternperl5ʽ.
     *
     * @param pattern  Ҫpattern
     * @param options  λ־
     *
     * @return Perl5ʽ
     *
     * @throws MalformedPatternException  patternʽȷ
     */
    public Pattern compile(char[] pattern, int options) throws MalformedPatternException {
        int perlOptions = 0;

        if ((options & CASE_INSENSITIVE_MASK) != 0) {
            perlOptions |= Perl5Compiler.CASE_INSENSITIVE_MASK;
        }

        if ((options & READ_ONLY_MASK) != 0) {
            perlOptions |= Perl5Compiler.READ_ONLY_MASK;
        }

        return compiler.compile(toPerl5Regex(pattern, options), perlOptions);
    }

    /**
     * patternperl5ʽַ.
     *
     * @param pattern  Ҫpattern
     * @param options  λ־
     *
     * @return Perl5ʽ
     *
     * @throws MalformedPatternException  patternʽȷ
     */
    protected abstract String toPerl5Regex(char[] pattern, int options)
            throws MalformedPatternException;

    /**
     * жַָǷperl5ʽַ
     *
     * @param ch ַ
     *
     * @return Ǳַ, 򷵻<code>true</code>
     */
    protected boolean isPerl5MetaChar(char ch) {
        return PERL5_META_CHARS.indexOf(ch) != -1;
    }

    /**
     * ȡôϢ.
     *
     * @param pattern  ǰpattern
     * @param index    ǰpatternindex
     *
     * @return Ϣ
     */
    protected String getDefaultErrorMessage(char[] pattern, int index) {
        return MessageFormat.format(ERROR_UNEXPECTED_CHAR,
                                    new Object[] {
            new Character(pattern[index]),
            new String(pattern, 0, index)
        });
    }
}