package com.meidusa.toolkit.common.util.regex;

import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.PatternMatcher;

/**
 * ʾһƥpattern.
 *
 * @version 
 * 
 */
public class MatchPattern {
    private Pattern pattern;

    /**
     * µpattern.
     */
    public MatchPattern() {
    }

    /**
     * µpattern.
     *
     * @param pattern ƥʽpattern
     */
    public MatchPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    /**
     * µpattern.
     *
     * @param compiler pattern
     * @param pattern  ƥʽpattern
     *
     * @throws MalformedPatternException patternϷ
     */
    public MatchPattern(PatternCompiler compiler, String pattern)
            throws MalformedPatternException {
        this.pattern = compiler.compile(pattern);
    }

    /**
     * µpattern.
     *
     * @param compiler pattern
     * @param pattern  ƥʽpattern
     * @param options  ѡ
     *
     * @throws MalformedPatternException patternϷ
     */
    public MatchPattern(PatternCompiler compiler, String pattern, int options)
            throws MalformedPatternException {
        this.pattern = compiler.compile(pattern, options);
    }

    /**
     * pattern.
     *
     * @param pattern ƥʽpattern
     */
    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    /**
     * ȡƥʽpattern.
     *
     * @return ƥʽpattern
     */
    public Pattern getPattern() {
        return pattern;
    }

    /**
     * ƥpattern, ɹ, 򷵻<code>true</code>.  ߿ͨ<code>context.getMatchItem()</code>ȡƥ.
     *
     * @param context  ƥ
     *
     * @return ƥɹ, 򷵻<code>true</code>
     */
    public boolean matches(MatchContext context) {
        PatternMatcher matcher = context.getMatcher();

        if (matcher.contains(context.getInputReset(), pattern)) {
            MatchItem item = context.createMatchItem(this, matcher.getMatch());

            context.setLastMatchItem(item);
            return true;
        }

        return false;
    }
}