package com.meidusa.toolkit.common.util.regex;

import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.PatternMatcherInput;

/**
 * һƥ, ͨ, һĲ, 滻, ȡƥַ.
 *
 * @version 
 * 
 */
public class MatchItem implements MatchResult {
    public static final int SUBSTITUTION_ONLY           = 0;
    public static final int SUBSTITUTION_WITH_PREMATCH  = 1;
    public static final int SUBSTITUTION_WITH_POSTMATCH = 2;
    private MatchContext    context;
    private MatchPattern    pattern;
    private MatchResult     result;

    /**
     * һƥ.
     *
     * @param context ƥcontext
     * @param pattern ƥpattern
     */
    public MatchItem(MatchContext context, MatchPattern pattern) {
        this.context = context;
        this.pattern = pattern;
    }

    /**
     * һƥ.
     *
     * @param context      ƥcontext
     * @param pattern      ƥpattern
     * @param result       ʽƥ
     */
    public MatchItem(MatchContext context, MatchPattern pattern, MatchResult result) {
        this(context, pattern);
        this.result = result;
    }

    /**
     * ȡòƥcontext.
     *
     * @return ƥcontext
     */
    public MatchContext getMatchContext() {
        return this.context;
    }

    /**
     * ȡòƥpattern.
     *
     * @return ƥpattern
     */
    public MatchPattern getMatchPattern() {
        return this.pattern;
    }

    /**
     * ȡֵַ.
     *
     * @return ֵַ
     */
    public String getInput() {
        return (String) this.context.getInput().getInput();
    }

    /**
     * ʵ<code>MatchResult</code>ӿ, ȡƥ䳤.
     *
     * @return ƥĳ
     */
    public int length() {
        return (result == null) ? 0
                                : result.length();
    }

    /**
     * ʵ<code>MatchResult</code>ӿ, ȡgroup.
     *
     * @return group, group0, Ҳƥ
     */
    public int groups() {
        return (result == null) ? 0
                                : result.groups();
    }

    /**
     * ʵ<code>MatchResult</code>ӿ, ȡָgroupӴ.
     *
     * @param group  group, 0ƥ
     *
     * @return ָgroupӴ
     */
    public String group(int group) {
        return (result == null) ? null
                                : result.group(group);
    }

    /**
     * ʵ<code>MatchResult</code>ӿ, ȡָgroupƥλ.
     *
     * @param group group, 0ƥ
     *
     * @return ָgroupƥλ, עƥַΪ0, λַĩβ, λַĳ.
     */
    public int begin(int group) {
        return (result == null) ? (-1)
                                : result.begin(group);
    }

    /**
     * ʵ<code>MatchResult</code>ӿ, ȡָgroupĩβƥλ.
     *
     * @param group group, 0ƥ
     *
     * @return ָgroupĩβƥλ, ָgroupڻδƥ, 򷵻-1, ƥַΪ0, 򷵻ʼλ
     */
    public int end(int group) {
        return (result == null) ? (-1)
                                : result.end(group);
    }

    /**
     * ʵ<code>MatchResult</code>ӿ, ȡָgroupַλ.
     *
     * @param group group, 0ƥ
     *
     * @return ָgroupַλ, ָgroupڻδƥ, 򷵻-1
     */
    public int beginOffset(int group) {
        return (result == null) ? (-1)
                                : result.beginOffset(group);
    }

    /**
     * ʵ<code>MatchResult</code>ӿ, ȡָgroupĩβַλ.
     *
     * @param group group, 0ƥ
     *
     * @return ָgroupĩβַλ, ָgroupڻδƥ, 򷵻-1, ƥַΪ0, 򷵻ʼλ
     */
    public int endOffset(int group) {
        return (result == null) ? (-1)
                                : result.endOffset(group);
    }

    /**
     * ʵ<code>MatchResult</code>ӿ, ȡƥַ, ൱<code>group(0)</code>.
     *
     * @return ƥַ
     */
    public String toString() {
        return (result == null) ? ""
                                : result.toString();
    }

    /**
     * ƥַǰӴ, ӵָ<code>StringBuffer</code>.
     *
     * @param buffer  Ҫӵ<code>StringBuffer</code>
     */
    public void appendPreMatch(StringBuffer buffer) {
        PatternMatcherInput input       = context.getInput();
        char[]              inputBuffer = input.getBuffer();
        int                 beginOffset = input.getBeginOffset();

        buffer.append(inputBuffer, beginOffset, beginOffset(0) - beginOffset);
    }

    /**
     * ƥַӴ, ӵָ<code>StringBuffer</code>.
     *
     * @param buffer  Ҫӵ<code>StringBuffer</code>
     */
    public void appendPostMatch(StringBuffer buffer) {
        PatternMatcherInput input       = context.getInput();
        char[]              inputBuffer = input.getBuffer();
        int                 beginOffset = endOffset(0);

        buffer.append(inputBuffer, beginOffset, input.length() - beginOffset);
    }

    /**
     * ƥַ, ӵָ<code>StringBuffer</code>.
     *
     * @param buffer  Ҫӵ<code>StringBuffer</code>
     */
    public void appendMatch(StringBuffer buffer) {
        PatternMatcherInput input       = context.getInput();
        char[]              inputBuffer = input.getBuffer();
        int                 beginOffset = beginOffset(0);

        buffer.append(inputBuffer, beginOffset, endOffset(0));
    }

    /**
     * 滻ַ뵽ָ<code>StringBuffer</code>.
     *
     * @param buffer        Ҫӵ<code>StringBuffer</code>
     * @param substitution  滻ʽ
     */
    public void appendSubstitution(StringBuffer buffer, String substitution) {
        context.getSubstitution(substitution)
               .appendSubstitution(buffer, this, 1, context.getInput(), context.getMatcher(),
                                   pattern.getPattern());
    }

    /**
     * 滻ƥַ.
     *
     * @param substitution 滻ַ
     *
     * @return 滻ַ
     */
    public String substitute(String substitution) {
        return substitute(substitution, SUBSTITUTION_ONLY);
    }

    /**
     * 滻ƥַ.
     *
     * @param substitution 滻ַ
     * @param options      滻ѡ, Ϊ<code>SUBSTITUTION_ONLY</code>,
     *        <code>SUBSTITUTION_WITH_PREMATCH</code><code>SUBSTITUTION_WITH_POSTMATCH</code>ǵ
     *
     * @return 滻ַ
     */
    public String substitute(String substitution, int options) {
        StringBuffer buffer = new StringBuffer();

        if ((options & SUBSTITUTION_WITH_PREMATCH) != 0) {
            appendPreMatch(buffer);
        }

        appendSubstitution(buffer, substitution);

        if ((options & SUBSTITUTION_WITH_POSTMATCH) != 0) {
            appendPostMatch(buffer);
        }

        return buffer.toString();
    }
}