package com.meidusa.toolkit.common.util.log4j;

import org.apache.log4j.LogManager;
import org.apache.log4j.helpers.FileWatchdog;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;

import org.w3c.dom.Element;

import java.net.URL;

import java.util.Properties;

/**
 * XMLļlog4jĹࡣLog4jĬϵ<code>DOMConfigurator</code>ȣṩpropertiesļбá
 *
 * @author Struct
 * @version $Id: DOMConfigurator.java,v 1.1.1.1 2005/11/13 02:22:56 struct Exp $
 */
public class DOMConfigurator extends org.apache.log4j.xml.DOMConfigurator {
    private Properties props;

    /**
     * ¶
     */
    public DOMConfigurator() {
        this(null);
    }

    /**
     * ¶
     *
     * @param props ļбõ
     */
    public DOMConfigurator(Properties props) {
        this.props = props;
    }

    /**
     * ʹXMLļlog4j
     *
     * @param filename ļ
     */
    public static void configure(String filename) {
        new DOMConfigurator().doConfigure(filename, LogManager.getLoggerRepository());
    }

    /**
     * ʹXMLļlog4j
     *
     * @param filename ļ
     * @param props ļбõ
     */
    public static void configure(String filename, Properties props) {
        new DOMConfigurator(props).doConfigure(filename, LogManager.getLoggerRepository());
    }

    /**
     * ʹXMLļlog4j
     *
     * @param url ļURL
     */
    public static void configure(URL url) {
        new DOMConfigurator().doConfigure(url, LogManager.getLoggerRepository());
    }

    /**
     * ʹXMLļlog4j
     *
     * @param url ļURL
     * @param props ļбõ
     */
    public static void configure(URL url, Properties props) {
        new DOMConfigurator(props).doConfigure(url, LogManager.getLoggerRepository());
    }

    /**
     * ʹXMLļlog4j
     *
     * @param element ļDOM element
     */
    public static void configure(Element element) {
        new DOMConfigurator().doConfigure(element, LogManager.getLoggerRepository());
    }

    /**
     * ʹXMLļlog4j
     *
     * @param element ļDOM element
     * @param props ļбõ
     */
    public static void configure(Element element, Properties props) {
        new DOMConfigurator(props).doConfigure(element, LogManager.getLoggerRepository());
    }

    /**
     * ʹXMLļlog4jͬʱļĸġ
     *
     * @param filename ļ
     */
    public static void configureAndWatch(String filename) {
        configureAndWatch(filename, null, FileWatchdog.DEFAULT_DELAY);
    }

    /**
     * ʹXMLļlog4jͬʱļĸġ
     *
     * @param filename ļ
     * @param props ļбõ
     */
    public static void configureAndWatch(String filename, Properties props) {
        configureAndWatch(filename, props, FileWatchdog.DEFAULT_DELAY);
    }

    /**
     * ʹXMLļlog4jͬʱļĸġ˷һ̵̣߳߳ڸָʱͻļǷ񱻴ı䣬ǣļжȡlog4já
     *
     * @param filename ļ
     * @param interval ̼߳ms
     */
    public static void configureAndWatch(String filename, long interval) {
        XMLWatchdog xdog = new XMLWatchdog(filename, null);

        xdog.setDelay(interval);
        xdog.start();
    }

    /**
     * ʹXMLļlog4jͬʱļĸġ˷һ̵̣߳߳ڸָʱͻļǷ񱻴ı䣬ǣļжȡlog4já
     *
     * @param filename ļ
     * @param props ļбõ
     * @param interval ̼߳ms
     */
    public static void configureAndWatch(String filename, Properties props, long interval) {
        XMLWatchdog xdog = new XMLWatchdog(filename, props);

        xdog.setDelay(interval);
        xdog.start();
    }

    /**
     * ԣЩԿļбá
     *
     * @param props 
     */
    public void setProperties(Properties props) {
        this.props = props;
    }

    /**
     * 滻ֵַе${xxx}滻ɾֵ
     *
     * @param value Ҫ滻ֵ
     *
     * @return 滻ֵ
     */
    protected String subst(String value) {
        try {
            return OptionConverter.substVars(value, props);
        } catch (IllegalArgumentException e) {
            LogLog.warn("Could not perform variable substitution.", e);
            return value;
        }
    }

    /**
     * ̡߳
     */
    private static class XMLWatchdog extends FileWatchdog {
        private Properties props;

        public XMLWatchdog(String filename, Properties props) {
            super(filename);
            this.props = props;
        }

        public void doOnChange() {
            new DOMConfigurator(props).doConfigure(filename, LogManager.getLoggerRepository());
        }
    }
}
