package com.meidusa.toolkit.common.util.collection;

import java.util.List;
import java.util.Map;

/**
 * <p>
 * <code>java.util.Map</code>.
 * </p>
 *
 * <p>
 * ӵ<code>java.util.Map</code>, <code>ListMap</code>е (<code>Map.Entry</code>).
 * Ҳ˵, Լֵ(key), Ҳ(index). ,
 * </p>
 *
 * <p>
 * ͨkey:
 * </p>
 * <pre>
 * Object value1 = listMap.get("key1");
 * </pre>
 *
 * <p>
 * ͨindex, ȡkeyvalue:
 * </p>
 * <pre>
 * Object value2 = listMap.get(2);
 * Object key2   = listMap.getKey(2);
 * </pre>
 *
 * <p>
 * ͨindex, ɾһ, رɾ:
 * </p>
 * <pre>
 * Map.Entry removedEntry = listMap.remove(3);
 * </pre>
 *
 * <p>
 * , ṩ: <code>keyList()</code>, <code>valueList()</code><code>entryList()</code>,
 * ȡkey, valueentry<code>List</code>. <code>Map.keySet()</code>, <code>Map.values()</code>
 * Լ<code>Map.entrySet()</code>, ֻṩȡkeyentry<code>Set</code>,
 * Լȡvalue<code>Collection</code>ķ.
 * </p>
 *
 * @version 
 * 
 */
public interface ListMap extends Map {
    /**
     * ָindexvalue.  indexΧ, <code>IndexOutOfBoundsException</code>.
     *
     * @param index Ҫصvalueֵ.
     *
     * @return ָindexvalue
     */
    Object get(int index);

    /**
     * ָindexkey. indexΧ, 򷵻<code>IndexOutOfBoundsException</code>.
     *
     * @param index Ҫصkeyֵ.
     *
     * @return ָindexkey
     */
    Object getKey(int index);

    /**
     * ɾָindex. indexΧ, 򷵻<code>IndexOutOfBoundsException</code>.
     *
     * @param index Ҫɾֵ.
     *
     * @return ɾ<code>Map.Entry</code>.
     */
    Map.Entry remove(int index);

    /**
     * key<code>List</code>.
     *
     * @return key<code>List</code>.
     */
    List keyList();

    /**
     * value<code>List</code>.
     *
     * @return value<code>List</code>.
     */
    List valueList();

    /**
     * entry<code>List</code>.
     *
     * @return entry<code>List</code>.
     */
    List entryList();
}