package com.meidusa.toolkit.common.util;

import java.io.File;
import java.io.FileInputStream;

import java.net.MalformedURLException;
import java.net.URL;

import java.util.Date;

/**
  * This is a temporary implementation. TypeHandler will handle the
  * pluggableness of OptionTypes and it will direct all of these types
  * of conversion functionalities to ConvertUtils component in Commons
  * already. BeanUtils I think.
  *
  * @version $Revision: 741425 $, $Date: 2009-02-05 22:10:54 -0800 (Thu, 05 Feb 2009) $
  */
public class TypeHandler
{
    /** String class */
    public static final Class STRING_VALUE = String.class;

    /** Object class */
    public static final Class OBJECT_VALUE = Object.class;

    /** Number class */
    public static final Class NUMBER_VALUE = Number.class;

    /** Date class */
    public static final Class DATE_VALUE = Date.class;

    /** Class class */
    public static final Class CLASS_VALUE = Class.class;

    /// can we do this one??
    // is meant to check that the file exists, else it errors.
    // ie) it's for reading not writing.

    /** FileInputStream class */
    public static final Class EXISTING_FILE_VALUE = FileInputStream.class;

    /** File class */
    public static final Class FILE_VALUE = File.class;

    /** File array class */
    public static final Class FILES_VALUE = File[].class;

    /** URL class */
    public static final Class URL_VALUE = URL.class;
	
	/**
	 * Base for Exceptions thrown during parsing of a command-line.
	 *
	 * @author bob mcwhirter (bob @ werken.com)
	 * @version $Revision: 680644 $, $Date: 2008-07-29 01:13:48 -0700 (Tue, 29 Jul 2008) $
	 */
	public static class ParseException extends Exception
	{
	    /**
	     * Construct a new <code>ParseException</code>
	     * with the specified detail message.
	     *
	     * @param message the detail message
	     */
	    public ParseException(String message)
	    {
	        super(message);
	    }
	}
    /**
     * Returns the <code>Object</code> of type <code>obj</code>
     * with the value of <code>str</code>.
     *
     * @param str the command line value
     * @param obj the type of argument
     * @return The instance of <code>obj</code> initialised with
     * the value of <code>str</code>.
     */
    public static Object createValue(String str, Object obj)
    throws ParseException
    {
        return createValue(str, (Class) obj);
    }

    /**
     * Returns the <code>Object</code> of type <code>clazz</code>
     * with the value of <code>str</code>.
     *
     * @param str the command line value
     * @param clazz the type of argument
     * @return The instance of <code>clazz</code> initialised with
     * the value of <code>str</code>.
     */
    public static Object createValue(String str, Class clazz)
    throws ParseException
    {
        if (STRING_VALUE == clazz)
        {
            return str;
        }
        else if (OBJECT_VALUE == clazz)
        {
            return createObject(str);
        }
        else if (NUMBER_VALUE == clazz)
        {
            return createNumber(str);
        }
        else if (DATE_VALUE == clazz)
        {
            return createDate(str);
        }
        else if (CLASS_VALUE == clazz)
        {
            return createClass(str);
        }
        else if (FILE_VALUE == clazz)
        {
            return createFile(str);
        }
        else if (EXISTING_FILE_VALUE == clazz)
        {
            return createFile(str);
        }
        else if (FILES_VALUE == clazz)
        {
            return createFiles(str);
        }
        else if (URL_VALUE == clazz)
        {
            return createURL(str);
        }
        else
        {
            return null;
        }
    }

    /**
      * Create an Object from the classname and empty constructor.
      *
      * @param classname the argument value
      * @return the initialised object, or null if it couldn't create
      * the Object.
      */
    public static Object createObject(String classname)
    throws ParseException
    {
        Class cl = null;

        try
        {
            cl = Class.forName(classname);
        }
        catch (ClassNotFoundException cnfe)
        {
            throw new ParseException("Unable to find the class: " + classname);
        }

        Object instance = null;

        try
        {
            instance = cl.newInstance();
        }
        catch (Exception e)
        {
            throw new ParseException(e.getClass().getName() + "; Unable to create an instance of: " + classname);
        }

        return instance;
    }

    /**
     * Create a number from a String. If a . is present, it creates a
     * Double, otherwise a Long.
     *
     * @param str the value
     * @return the number represented by <code>str</code>, if <code>str</code>
     * is not a number, null is returned.
     */
    public static Number createNumber(String str)
    throws ParseException
    {
        try
        {
            if (str.indexOf('.') != -1)
            {
                return Double.valueOf(str);
            }
            else
            {
                return Long.valueOf(str);
            }
        }
        catch (NumberFormatException e)
        {
            throw new ParseException(e.getMessage());
        }
    }

    /**
     * Returns the class whose name is <code>classname</code>.
     *
     * @param classname the class name
     * @return The class if it is found, otherwise return null
     */
    public static Class createClass(String classname)
    throws ParseException
    {
        try
        {
            return Class.forName(classname);
        }
        catch (ClassNotFoundException e)
        {
            throw new ParseException("Unable to find the class: " + classname);
        }
    }

    /**
     * Returns the date represented by <code>str</code>.
     *
     * @param str the date string
     * @return The date if <code>str</code> is a valid date string,
     * otherwise return null.
     */
    public static Date createDate(String str)
    throws ParseException
    {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    /**
     * Returns the URL represented by <code>str</code>.
     *
     * @param str the URL string
     * @return The URL is <code>str</code> is well-formed, otherwise
     * return null.
     */
    public static URL createURL(String str)
    throws ParseException
    {
        try
        {
            return new URL(str);
        }
        catch (MalformedURLException e)
        {
            throw new ParseException("Unable to parse the URL: " + str);
        }
    }

    /**
     * Returns the File represented by <code>str</code>.
     *
     * @param str the File location
     * @return The file represented by <code>str</code>.
     */
    public static File createFile(String str)
    throws ParseException
    {
        return new File(str);
    }

    /**
     * Returns the File[] represented by <code>str</code>.
     *
     * @param str the paths to the files
     * @return The File[] represented by <code>str</code>.
     */
    public static File[] createFiles(String str)
    throws ParseException
    {
        // to implement/port:
        //        return FileW.findFiles(str);
        throw new UnsupportedOperationException("Not yet implemented");
    }
}
