package com.meidusa.toolkit.common.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

import java.text.MessageFormat;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

/**
 * ַйصС.
 *
 * @version 
 * 
 */
public class StringUtil {
    private static final OutputStream DUMMY_OUTPUT_STREAM = new ByteArrayOutputStream(0);
    private static final String       SYSTEM_CHARSET =
            new OutputStreamWriter(DUMMY_OUTPUT_STREAM).getEncoding();

    /* ============================================================================ */
    /* йresource bundleķ                                              */
    /* ============================================================================ */

    /**
     * ʹ<code>MessageFormat</code>ʽַ.
     *
     * @param bundle  resource bundle
     * @param key     Ҫҵļ
     * @param params  
     *
     * @return keyӦַ
     *
     * @throws NullPointerException      resource keyΪ<code>null</code>resource
     *         bundleΪ<code>null</code>
     * @throws MissingResourceException  ָresource keyδҵ
     */
    public static String getMessage(ResourceBundle bundle, Object key, Object[] params) {
        String pattern = bundle.getString(key.toString());

        if ((params == null) || (params.length == 0)) {
            return pattern;
        }

        return MessageFormat.format(pattern, params);
    }

    /**
     * ʹ<code>MessageFormat</code>ʽַ.
     *
     * @param bundle  resource bundle
     * @param key     Ҫҵļ
     * @param param1  1
     *
     * @return keyӦַ
     *
     * @throws NullPointerException      resource keyΪ<code>null</code>resource
     *         bundleΪ<code>null</code>
     * @throws MissingResourceException  ָresource keyδҵ
     */
    public static String getMessage(ResourceBundle bundle, Object key, Object param1) {
        return getMessage(bundle, key, new Object[] {
            param1
        });
    }

    /**
     * ʹ<code>MessageFormat</code>ʽַ.
     *
     * @param bundle  resource bundle
     * @param key     Ҫҵļ
     * @param param1  1
     * @param param2  2
     *
     * @return keyӦַ
     *
     * @throws NullPointerException      resource keyΪ<code>null</code>resource
     *         bundleΪ<code>null</code>
     * @throws MissingResourceException  ָresource keyδҵ
     */
    public static String getMessage(ResourceBundle bundle, Object key, Object param1, Object param2) {
        return getMessage(bundle, key, new Object[] {
            param1,
            param2
        });
    }

    /**
     * ʹ<code>MessageFormat</code>ʽַ.
     *
     * @param bundle  resource bundle
     * @param key     Ҫҵļ
     * @param param1  1
     * @param param2  2
     * @param param3  3
     *
     * @return keyӦַ
     *
     * @throws NullPointerException      resource keyΪ<code>null</code>resource
     *         bundleΪ<code>null</code>
     * @throws MissingResourceException  ָresource keyδҵ
     */
    public static String getMessage(ResourceBundle bundle, Object key, Object param1, Object param2,
                                    Object param3) {
        return getMessage(bundle, key, new Object[] {
            param1,
            param2,
            param3
        });
    }

    /**
     * ʹ<code>MessageFormat</code>ʽַ.
     *
     * @param bundle  resource bundle
     * @param key     Ҫҵļ
     * @param param1  1
     * @param param2  2
     * @param param3  3
     * @param param4  4
     *
     * @return keyӦַ
     *
     * @throws NullPointerException      resource keyΪ<code>null</code>resource
     *         bundleΪ<code>null</code>
     * @throws MissingResourceException  ָresource keyδҵ
     */
    public static String getMessage(ResourceBundle bundle, Object key, Object param1, Object param2,
                                    Object param3, Object param4) {
        return getMessage(bundle, key,
                          new Object[] {
            param1,
            param2,
            param3,
            param4
        });
    }

    /**
     * ʹ<code>MessageFormat</code>ʽַ.
     *
     * @param bundle  resource bundle
     * @param key     Ҫҵļ
     * @param param1  1
     * @param param2  2
     * @param param3  3
     * @param param4  4
     * @param param5  5
     *
     * @return keyӦַ
     *
     * @throws NullPointerException      resource keyΪ<code>null</code>resource
     *         bundleΪ<code>null</code>
     * @throws MissingResourceException  ָresource keyδҵ
     */
    public static String getMessage(ResourceBundle bundle, Object key, Object param1, Object param2,
                                    Object param3, Object param4, Object param5) {
        return getMessage(bundle, key,
                          new Object[] {
            param1,
            param2,
            param3,
            param4,
            param5
        });
    }

    /**
     * ַǷΪ<code>null</code>ַ.
     *
     * @param str Ҫַ
     *
     * @return Ϊ, 򷵻<code>true</code>
     */
    public static boolean isEmpty(String str) {
        return (str == null) || (str.length() == 0);
    }

    /**
     * ȡϵͳַ.
     *
     * @return ϵͳַ
     */
    public static String getSystemCharset() {
        return SYSTEM_CHARSET;
    }

    /**
     * ȡַ, ַָ, ׳<code>UnsupportedEncodingException</code>.
     *
     * @param charset ַ
     *
     * @return ַ
     *
     * @throws UnsupportedEncodingException ַָ
     */
    public static String getCanonicalCharset(String charset)
            throws UnsupportedEncodingException {
        return new OutputStreamWriter(DUMMY_OUTPUT_STREAM, charset).getEncoding();
    }

    /**
     * ȡַ, ַָ, 򷵻<code>null</code>.
     *
     * @param charset ַ
     *
     * @return ַ, ַָ, 򷵻<code>null</code>
     */
    public static String getCanonicalCharsetQuiet(String charset) {
        try {
            return getCanonicalCharset(charset);
        } catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    /**
     * չַ, "$"""еıת<code>System.getProperties()</code>еֵ.
     *
     * @param value       Ҫתֵ
     *
     * @return չֵ
     */
    public static String expendProperty(String value) {
        return expendProperty(value, System.getProperties());
    }

    /**
     * չַ, "$"""еıתָpropertiesеֵ.
     *
     * @param value       Ҫתֵ
     * @param properties  õı
     *
     * @return չֵ
     */
    public static String expendProperty(String value, Map properties) {
        if (value == null) {
            return null;
        }

        int i = value.indexOf("${", 0);

        if (i == -1) {
            return value;
        }

        StringBuffer buffer = new StringBuffer(value.length());
        int          length = value.length();
        int          j      = 0;

        while (i < length) {
            if (i > j) {
                buffer.append(value.substring(j, i));
                j = i;
            }

            int k;

            for (k = i + 2; (k < length) && (value.charAt(k) != '}'); k++) {
            }

            if (k == length) {
                buffer.append(value.substring(i, k));
                break;
            }

            String propertyName = value.substring(i + 2, k);

            if (propertyName.equals("/")) {
                buffer.append(File.separatorChar);
            } else {
                Object propertyValue = properties.get(propertyName);

                if (propertyValue != null) {
                    buffer.append(propertyValue);
                } else {
                    buffer.append("${").append(propertyName).append("}");
                }
            }

            j = k + 1;
            i = value.indexOf("${", j);

            if (i == -1) {
                if (j < length) {
                    buffer.append(value.substring(j, length));
                }

                break;
            }
        }

        return buffer.toString();
    }

    // add by roy

    /**
     * ݷַָָ Return List,after split Split a String by a splitter(such as ",","hai",...)
     *
     * @param sStr       Ҫַָ
     * @param sSplitter  ָ
     *
     * @return һзָõַListָʧܽnull,ַûаָķָ
     *         ֻһԪصַ飬ԪؾǸַַֻзָnull
     */
    public static List splitStr(String sStr, String sSplitter) {
        if ((sStr == null) || (sStr.length() <= 0) || (sSplitter == null)
                || (sSplitter.length() <= 0)) {
            return null;
        }

        StringTokenizer st     = new StringTokenizer(sStr, sSplitter);
        List            result = new ArrayList();

        while (st.hasMoreTokens()) {
            result.add(st.nextToken().trim());
        }

        return result;
    }

    // add by roy
    /**
     * һStringǷһ֣磺7897897->true,789t67 -> false
     * ע⣺һ᷵false. Return true if the string represents a number
     *
     * @param str  Уַ
     *
     * @return һ׼֣true򷵻false
     */
    public static boolean isNum(String str) {
        if ((str == null) || (str.length() <= 0)) {
            return false;
        }

        char[] ch = str.toCharArray();

        for (int i = 0; i < str.length(); i++) {
            if (!Character.isDigit(ch[i])) {
                return false;
            }
        }

        return true;
    }

}