package com.meidusa.toolkit.common.util;

import com.meidusa.toolkit.common.util.collection.ArrayHashSet;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;

import java.lang.reflect.Method;

import java.net.URL;

import java.util.Enumeration;
import java.util.Set;

import org.apache.log4j.Logger;

/**
 * <p>
 * ҲװԴĸ.
 * </p>
 *
 * <p>
 * <code>ClassFinder</code>ԴЧ,
 * ൱<code>ClassLoader.loadClass</code><code>ClassLoader.getResource</code>.
 * <code>ClassFinder</code>ȳԴ<code>Thread.getContextClassLoader()</code>ȡ<code>ClassLoader</code>вװԴ.
 * ַڶ༶<code>ClassLoader</code>, ҲԴ.
 * </p>
 *
 * <p>
 * :
 * </p>
 *
 * <ul>
 * <li>
 * <code>A</code>Ǵϵͳ<code>ClassLoader</code>װ(classpath)
 * </li>
 * <li>
 * <code>B</code>Web Applicationеһ, servlet<code>ClassLoader</code>̬װ
 * </li>
 * <li>
 * Դļ<code>C.properties</code>ҲWeb Application, ֻservletĶ̬<code>ClassLoader</code>ҵ
 * </li>
 * <li>
 * <code>B</code>ù<code>A</code>ķ, ϣͨ<code>A</code>ȡԴļ<code>C.properties</code>
 * </li>
 * </ul>
 *
 * <p>
 * <code>A</code>ʹ<code>getClass().getClassLoader().getResource(&quot;C.properties&quot;)</code>,
 * ͻʧ, Ϊϵͳ<code>ClassLoader</code>ҵԴ.
 * AʹClassFinder.getResource(&quot;C.properties&quot;), ͿҵԴ,
 * ΪClassFinder<code>Thread.currentThead().getContextClassLoader()</code>ȡservlet<code>ClassLoader</code>,
 * ӶҵԴļ.
 * </p>
 *
 * <p>
 * ע, <code>Thread.getContextClassLoader()</code>JDK1.2֮е, ڵͰ汾JDK,
 * <code>ClassFinder</code>Чֱӵ<code>ClassLoader</code>ȫͬ.
 * </p>
 *
 * @version 
 * 
 */
public class ContextClassLoader {
	private static Logger logger = Logger.getLogger(ContextClassLoader.class);
    /**
     * JDK1.2, <code>Thread.getContextClassLoader()</code>. ڵͰ汾JDK,
     * ˱Ϊ<code>null</code>.
     */
    private static Method GET_CONTEXT_CLASS_LOADER_METHOD = null;

    static {
        try {
            GET_CONTEXT_CLASS_LOADER_METHOD = Thread.class.getMethod("getContextClassLoader", null);
        } catch (NoSuchMethodException e) {
            // JDK 1.2.
        }
    }

    /**
     * <p>
     * <code>ClassLoader</code>ȡresource URL. ˳:
     * </p>
     *
     * <ol>
     * <li>
     * ڵǰ̵߳<code>ClassLoader</code>в.
     * </li>
     * <li>
     * װԼ<code>ClassLoader</code>в.
     * </li>
     * <li>
     * ͨ<code>ClassLoader.getSystemResource</code>.
     * </li>
     * </ol>
     *
     *
     * @param resourceName ҪҵԴ, &quot;/&quot;ָıʶַ
     *
     * @return resourceURL, ûҵ, 򷵻ؿ. б֤ظURL.
     */
    public static URL[] getResources(String resourceName) {
        ClassLoader classLoader = null;
        Set         urlSet = new ArrayHashSet();
        boolean     found  = false;


        // Ŵӵǰ̵߳ClassLoaderв.
        found = getResources(urlSet, resourceName, getClassLoader(), false);

        // ûҵ, ŴװԼClassLoaderв.
        if (!found) {
            getResources(urlSet, resourceName, ContextClassLoader.class.getClassLoader(), false);
        }

        // ĳ: ϵͳClassLoaderв(JDK1.2),
        // JDKڲClassLoaderв(JDK1.2).
        if (!found) {
            getResources(urlSet, resourceName, null, true);
        }

        if (found) {
            return (URL[]) urlSet.toArray(new URL[urlSet.size()]);
        }

        return new URL[0];
    }

    /**
     * ָclass loaderвָƵresource, ҵresourceURLָļ.
     *
     * @param urlSet          resource URLļ
     * @param resourceName    Դ
     * @param classLoader     װ
     * @param sysClassLoader  Ƿsystem class loaderװԴ
     *
     * @return ҵ, 򷵻<code>true</code>
     */
    private static boolean getResources(Set urlSet, String resourceName, ClassLoader classLoader,
                                        boolean sysClassLoader) {
        Enumeration i = null;

        try {
            if (classLoader != null) {
                i = classLoader.getResources(resourceName);
            } else if (sysClassLoader) {
                i = ClassLoader.getSystemResources(resourceName);
            }
        } catch (IOException e) {
        }

        if ((i != null) && i.hasMoreElements()) {
            while (i.hasMoreElements()) {
                urlSet.add(i.nextElement());
            }

            return true;
        }

        return false;
    }

    /**
     * <p>
     * <code>ClassLoader</code>ȡresource URL. ˳:
     * </p>
     *
     * <ol>
     * <li>
     * ڵǰ̵߳<code>ClassLoader</code>в.
     * </li>
     * <li>
     * װԼ<code>ClassLoader</code>в.
     * </li>
     * <li>
     * ͨ<code>ClassLoader.getSystemResource</code>.
     * </li>
     * </ol>
     *
     *
     * @param resourceName ҪҵԴ, &quot;/&quot;ָıʶַ
     *
     * @return resourceURL
     */
    public static URL getResource(String resourceName) {
        ClassLoader classLoader = null;
        URL         url = null;


        // Ŵӵǰ̵߳ClassLoaderв.
        classLoader = getClassLoader();

        if (classLoader != null) {
            url = classLoader.getResource(resourceName);

            if (url != null) {
                return url;
            }
        }


        // ûҵ, ŴװԼClassLoaderв.
        classLoader = ContextClassLoader.class.getClassLoader();

        if (classLoader != null) {
            url = classLoader.getResource(resourceName);

            if (url != null) {
                return url;
            }
        }

        // ĳ: ϵͳClassLoaderв(JDK1.2),
        // JDKڲClassLoaderв(JDK1.2).
        return ClassLoader.getSystemResource(resourceName);
    }

    /**
     * <code>ClassLoader</code>ȡresource.
     * ൱<code>getResource(resourceName).openStream()</code>.
     *
     * @param resourceName ҪҵԴ, "/"ָıʶַ
     *
     * @return resource
     */
    public static InputStream getResourceAsStream(String resourceName) {
        URL url = getResource(resourceName);

        try {
            if (url != null) {
                return url.openStream();
            }
        } catch (IOException e) {
            // URLʧ.
        }

        return null;
    }

    /**
     * ӵǰ̵߳<code>ClassLoader</code>װ.  JDK1.2, ൱<code>Class.forName</code>.
     *
     * @param className Ҫװ
     *
     * @return װ
     *
     * @throws ClassNotFoundException ûҵ
     */
    public static Class loadClass(String className)
            throws ClassNotFoundException {
        return loadClass(className, true, null);
    }

    /**
     * ָ<code>ClassLoader</code>װ.  δָ<code>ClassLoader</code>,
     * ӵǰ̵߳<code>ClassLoader</code>װ.
     *
     * @param className   Ҫװ
     * @param initialize  ǷҪʼ
     * @param classLoader ָ<code>ClassLoader</code>װ
     *
     * @return װ
     *
     * @throws ClassNotFoundException ûҵ
     */
    public static Class loadClass(String className, boolean initialize, ClassLoader classLoader)
            throws ClassNotFoundException {
        if (classLoader == null) {
            classLoader = getClassLoader();
        }

        return Class.forName(className, initialize, classLoader);
    }

    /**
     * ȡõǰ̵߳<code>ClassLoader</code>. ҪJDK1.2߰汾JDK֧.
     *
     * @return JDK1.2ǰ汾, null. 򷵻صǰ̵߳<code>ClassLoader</code>.
     */
    public static ClassLoader getClassLoader() {
        if (GET_CONTEXT_CLASS_LOADER_METHOD != null) {
            try {
                return (ClassLoader) GET_CONTEXT_CLASS_LOADER_METHOD.invoke(Thread.currentThread(),
                                                                            null);
            } catch (Throwable e) {
                return null;
            }
        }

        return null;
    }
    
    public static File findLibrary(File parent,String libraryName){
    	String s = System.mapLibraryName(libraryName);
    	return new File(parent,s);
    }
    
    /**
     * ѭ
     * 	1ȸݻ ${project.library.path}
     * 	2 ${project.home}/native
     * 	3 ${project.home}/.
     * 	4ǰ·  
     * 	5 ${java.library.path}
     * @param libraryName
     */
    public static void loadLibrary(String libraryName){
    	String projectLibraryPath = System.getProperty("project.library.path");
    	File libraryFile = null;
    	boolean loaded = false;
    	if(projectLibraryPath != null){
    		libraryFile = findLibrary(new File(projectLibraryPath),libraryName);
    		if(libraryFile.exists()){
    			loadLibrary(libraryFile.getParentFile(),libraryName);
    			loaded = true;
    		}else{
    			loaded = loadFromHomePath(libraryName);
    		}
    	}else{
    		loaded = loadFromHomePath(libraryName);
    	}
    	
    	if(!loaded){
    		libraryFile = findLibrary(new File("."),libraryName);
			if(libraryFile.exists()){
				loadLibrary(libraryFile.getParentFile(),libraryName);
			}else{
				System.loadLibrary(libraryName);
				logger.info("libraryName="+System.mapLibraryName(libraryName)+" load from system path");
			}
    	}
    }
    
    private static boolean loadFromHomePath(String libraryName){
    	File libraryFile = null;
    	String projectHome = System.getProperty("project.home");
		if(projectHome != null){
			libraryFile = findLibrary(new File(projectHome,"native"),libraryName);
			if(libraryFile.exists()){
				loadLibrary(libraryFile.getParentFile(),libraryName);
				logger.info("loaded from "+libraryFile.getAbsolutePath());
				return true;
			}else{
				libraryFile = findLibrary(new File(projectHome),libraryName);
				if(libraryFile.exists()){
					loadLibrary(libraryFile.getParentFile(),libraryName);
					logger.info("loaded from "+libraryFile.getAbsolutePath());
					return true;
				}
			}
		}
		return false;
    }
    /**
     * 
     * @param parent ǰڵļ
     * @param libraryName
     */
    public static void loadLibrary(File parent,String libraryName){
    	Method llm;
    	try {
	    	llm = ClassLoader.class.getDeclaredMethod("loadLibrary0", new Class[]{Class.class,File.class});
	    	llm.setAccessible(true);
	    	File lib = findLibrary(parent,libraryName);
	    	if(!lib.exists()){
	    		logger.error("loadLibrary error,File not found:"+lib.getAbsolutePath());
	    		throw new RuntimeException("File not found:"+lib.getAbsolutePath());
	    	}
	    	llm.invoke(null, new Object[]{ContextClassLoader.class,lib});
	    	logger.info("loaded from "+lib.getAbsolutePath());
    	} catch (Exception e) {
    		throw new RuntimeException(e);
    	}
    }
    
}