/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.common.poolable;

import com.meidusa.toolkit.common.poolable.GenericObjectPool;
import com.meidusa.toolkit.common.poolable.PoolableObject;
import com.meidusa.toolkit.common.poolable.PoolableObjectFactoryWapper;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;

public class PoolableObjectPool
extends GenericObjectPool {
    public PoolableObjectPool() {
        this(null, 8, 1, -1L, 8, 0, false, false, -1L, 3, 1800000L, false);
    }

    public PoolableObjectPool(PoolableObjectFactory factory) {
        this(factory, 8, 1, -1L, 8, 0, false, false, -1L, 3, 1800000L, false);
    }

    public PoolableObjectPool(PoolableObjectFactory factory, GenericObjectPool.Config config) {
        this(factory, config.maxActive, config.whenExhaustedAction, config.maxWait, config.maxIdle, config.minIdle, config.testOnBorrow, config.testOnReturn, config.timeBetweenEvictionRunsMillis, config.numTestsPerEvictionRun, config.minEvictableIdleTimeMillis, config.testWhileIdle);
    }

    public PoolableObjectPool(PoolableObjectFactory factory, int maxActive) {
        this(factory, maxActive, 1, -1L, 8, 0, false, false, -1L, 3, 1800000L, false);
    }

    public PoolableObjectPool(PoolableObjectFactory factory, int maxActive, byte whenExhaustedAction, long maxWait) {
        this(factory, maxActive, whenExhaustedAction, maxWait, 8, 0, false, false, -1L, 3, 1800000L, false);
    }

    public PoolableObjectPool(PoolableObjectFactory factory, int maxActive, byte whenExhaustedAction, long maxWait, boolean testOnBorrow, boolean testOnReturn) {
        this(factory, maxActive, whenExhaustedAction, maxWait, 8, 0, testOnBorrow, testOnReturn, -1L, 3, 1800000L, false);
    }

    public PoolableObjectPool(PoolableObjectFactory factory, int maxActive, byte whenExhaustedAction, long maxWait, int maxIdle) {
        this(factory, maxActive, whenExhaustedAction, maxWait, maxIdle, 0, false, false, -1L, 3, 1800000L, false);
    }

    public PoolableObjectPool(PoolableObjectFactory factory, int maxActive, byte whenExhaustedAction, long maxWait, int maxIdle, boolean testOnBorrow, boolean testOnReturn) {
        this(factory, maxActive, whenExhaustedAction, maxWait, maxIdle, 0, testOnBorrow, testOnReturn, -1L, 3, 1800000L, false);
    }

    public PoolableObjectPool(PoolableObjectFactory factory, int maxActive, byte whenExhaustedAction, long maxWait, int maxIdle, boolean testOnBorrow, boolean testOnReturn, long timeBetweenEvictionRunsMillis, int numTestsPerEvictionRun, long minEvictableIdleTimeMillis, boolean testWhileIdle) {
        this(factory, maxActive, whenExhaustedAction, maxWait, maxIdle, 0, testOnBorrow, testOnReturn, timeBetweenEvictionRunsMillis, numTestsPerEvictionRun, minEvictableIdleTimeMillis, testWhileIdle);
    }

    public PoolableObjectPool(PoolableObjectFactory factory, int maxActive, byte whenExhaustedAction, long maxWait, int maxIdle, int minIdle, boolean testOnBorrow, boolean testOnReturn, long timeBetweenEvictionRunsMillis, int numTestsPerEvictionRun, long minEvictableIdleTimeMillis, boolean testWhileIdle) {
        super(factory, maxActive, whenExhaustedAction, maxWait, maxIdle, 0, testOnBorrow, testOnReturn, timeBetweenEvictionRunsMillis, numTestsPerEvictionRun, minEvictableIdleTimeMillis, testWhileIdle);
        this.setFactory(factory);
    }

    public void setFactory(PoolableObjectFactory factory) {
        if (!(factory instanceof PoolableObjectFactoryWapper)) {
            PoolableObjectFactoryWapper wapper = new PoolableObjectFactoryWapper(this, factory);
            super.setFactory((PoolableObjectFactory)wapper);
        } else {
            super.setFactory(factory);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean validate() {
        int count = 0;
        while (true) {
            boolean excetion = false;
            Object object = null;
            try {
                object = super.borrowObject();
                if (object instanceof PoolableObject) {
                    if (((PoolableObject)object).checkValid()) {
                        this.setValid(true);
                        return true;
                    }
                    if (this.isValid()) continue;
                    return false;
                }
                this.setValid(true);
                return true;
            }
            catch (Exception e) {
                excetion = true;
                return excetion;
            }
            finally {
                if (object != null) {
                    try {
                        this.returnObject(object);
                    }
                    catch (Exception exception) {}
                }
                if (excetion && this.getNumActive() == 0) {
                    this.setValid(false);
                    return false;
                }
                if (++count > 10) return false;
                continue;
            }
            break;
        }
    }
}

