package com.meidusa.toolkit.common.heartbeat;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.DelayQueue;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 
 * @author Struct
 *
 */
public class HeartbeatManager {
	static Logger logger = LoggerFactory.getLogger(HeartbeatManager.class);
	protected static final BlockingQueue<HeartbeatDelayed> HEART_BEAT_QUEUE = new DelayQueue<HeartbeatDelayed>();
	private static boolean isRunning = true;
	private static Thread  heartbeatManagerThread = new Thread() {
			{
				this.setDaemon(true);
				this.setName("HeartbeatManagerThread");
			}

			public void run() {
				HeartbeatDelayed delayed = null;
				while (isRunning) {
					try {
						delayed = HEART_BEAT_QUEUE.take();
						Status status = delayed.doCheck();
						if (logger.isInfoEnabled()) {
							logger.info("checked task taskName="
									+ delayed.getName() + ", Status="
									+ status);
						}
						
						if (delayed.isCycle()) {
							delayed.reset();
							HeartbeatManager.addHeartbeat(delayed);
						}else{
							if (status == Status.INVALID) {
								delayed.reset();
								HeartbeatManager.addHeartbeat(delayed);
							}else{
								delayed.cancel();
							}
						}
					} catch (Exception e) {
						logger.error("check task error", e);
					}
				}
			}
	};

	static{
		heartbeatManagerThread.start();
	}
	public static void addHeartbeat(HeartbeatDelayed delay) {
		if (!HEART_BEAT_QUEUE.contains(delay)) {
			HEART_BEAT_QUEUE.offer(delay);
		}
	}

	public static void removeHeartbeat(HeartbeatDelayed delay) {
		HEART_BEAT_QUEUE.remove(delay);
	}
	
	public static void shutdown(){
		isRunning = false;
		heartbeatManagerThread.stop();
	}
}
