/**
 * <pre>
 * 	This program is free software; you can redistribute it and/or modify it under the terms of 
 * the GNU AFFERO GENERAL PUBLIC LICENSE as published by the Free Software Foundation; either version 3 of the License, 
 * or (at your option) any later version. 
 * 
 * 	This program is distributed in the hope that it will be useful, 
 * but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 * See the GNU AFFERO GENERAL PUBLIC LICENSE for more details. 
 * 	You should have received a copy of the GNU AFFERO GENERAL PUBLIC LICENSE along with this program; 
 * if not, write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * </pre>
 */
package com.meidusa.toolkit.common.poolable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.log4j.Logger;


import com.meidusa.toolkit.common.bean.util.Initialisable;
import com.meidusa.toolkit.common.heartbeat.HeartbeatManager;
import com.meidusa.toolkit.common.heartbeat.Status;



/**
 * <pre>
 * Pool ṩؾ⡢failoverHA
 * Load Balance ObjectPoolobject ʵ{@link PoolableObject}
 * Ĭṩ2ָؾⷽ
 * <li>ѯѯ䵽ÿpoolÿpoolȽƽ</li>
 * <li>æ̶ȣPoolActive NumһСActive Numȷ</li>
 * &#064;author &lt;a href=mailto:piratebase@sina.com&gt;Struct chen&lt;/a&gt;
 * </pre>
 */
public class MultipleLoadBalanceObjectPool implements ObjectPool,Initialisable {
	private static Logger logger = Logger.getLogger(MultipleLoadBalanceObjectPool.class);
	static int HashMod = Integer.valueOf(System.getProperty("venus.HashFunction.mod", "1024"));
	
	public static class DefaultFunction implements HashFunction{
		  
	    public int hash(Object key) {  

	    	if(key == null){
	    		return 0;
	    	}else{
	    		return Math.abs(key.hashCode()) % HashMod;
	    	}
	    }
	}
	
	static HashFunction function = new DefaultFunction();
	
	static {
		String functionName = System.getProperty("venus.HashFunction.class",DefaultFunction.class.getName());
		try {
			Class clazz =  Class.forName(functionName);
			function = (HashFunction)clazz.newInstance();
		} catch (Exception e) {
			logger.error("hashFunction="+functionName+" not found,using default:"+DefaultFunction.class.getName(),e);
		}
	}
	
    public static final int LOADBALANCING_ROUNDROBIN  = 1;
    public static final int LOADBALANCING_WEIGHTBASED = 2;
    public static final int LOADBALANCING_HA          = 3;
    public static final int LOADBALANCING_HASH  	  = 4;
    private boolean         enable;
    private String name;
    
    
    protected static class ActiveNumComparator implements Comparator<ObjectPool> {

        public int compare(ObjectPool o1, ObjectPool o2) {
            return o1.getNumActive() - o2.getNumActive();
        }
    }



    /**
     * ؾ㷨
     */
    private int                               loadbalance;

    private AtomicLong                        currentCount  = new AtomicLong(0);
    private ObjectPool[]                      objectPools;

    private ObjectPool[]                      runtimeObjectPools;

    private int index = 0;
    private ActiveNumComparator               comparator    = new ActiveNumComparator();
	private boolean valid;

	private SortedMap<Integer, ObjectPool> circle = new TreeMap<Integer, ObjectPool>(); 
    public MultipleLoadBalanceObjectPool(){
    }

    public MultipleLoadBalanceObjectPool(int loadbalance, ObjectPool... objectPools){
    	this.loadbalance = loadbalance;
    	setObjectPools(objectPools);
    }

    public void setLoadbalance(int loadbalance) {
        this.loadbalance = loadbalance;
    }

    public void setObjectPools(ObjectPool[] objectPools) {
    	this.objectPools = objectPools;
        this.runtimeObjectPools = objectPools.clone();
        
        if(runtimeObjectPools.length>0){
	    	for(int i=0;i < runtimeObjectPools.length;i++){
	    		
	    		circle.put(((HashMod / runtimeObjectPools.length) * i), runtimeObjectPools[i]);
	    	}
        }
    }

    public void addObject() throws Exception {
        throw new UnsupportedOperationException();
    }

	public ObjectPool getConsistenthashPool(Object key) {
		if (circle.isEmpty()) {
			return null;
		}
		int hash = function.hash(key!=null?key.toString():"");
		if (!circle.containsKey(hash)) {
			SortedMap<Integer, ObjectPool> tailMap = circle.tailMap(hash);
			hash = tailMap.isEmpty() ? circle.firstKey() : tailMap.firstKey();
		}
		return circle.get(hash);
	}
    
    public Object borrowObject() throws Exception {
        ObjectPool pool = null;
        
        while(true){
        	final ObjectPool[] poolsTemp = runtimeObjectPools;
	        if (poolsTemp.length == 0) {
	            throw new Exception("poolName="+name+", no valid pools");
	        }
	
	        if (loadbalance == LOADBALANCING_ROUNDROBIN) {
	            long current = currentCount.getAndIncrement();
	            pool = poolsTemp[(int) (current % poolsTemp.length)];
	        } else if (loadbalance == LOADBALANCING_WEIGHTBASED) {
	            if (poolsTemp.length > 1) {
	                ObjectPool[] objectPoolsCloned = poolsTemp.clone();
	                Arrays.sort(objectPoolsCloned, comparator);
	                pool = objectPoolsCloned[0];
	            } else if (poolsTemp.length == 1) {
	                pool = poolsTemp[0];
	            }
	        } else if (loadbalance == LOADBALANCING_HA) {
	            // HA,ֻҪЧpool
	        	if(index < poolsTemp.length){
	        		pool = poolsTemp[index];
	        	}else{
	        		pool = poolsTemp[0];
	        	}
	        } else {
	            throw new Exception("poolName="+name+" loadbalance parameter error,parameter loadbalance in [1,2,3]");
	        }
	        
	        if(!pool.isValid()){
	        	validate();
	        	continue;
	        }else{
	        	break;
	        }
        }
        
        return pool.borrowObject();
        

    }

    public void clear() throws Exception, UnsupportedOperationException {
    	//do not clear internal pools
    	/*for (ObjectPool pool : objectPools) {
            pool.clear();
        }*/

    }

   

    public int getNumActive() throws UnsupportedOperationException {
        int active = 0;
        for (ObjectPool pool : objectPools) {
            active += pool.getNumActive();
        }
        return active;
    }

    public int getNumIdle() throws UnsupportedOperationException {
        int idle = 0;
        for (ObjectPool pool : objectPools) {
            idle += pool.getNumIdle();
        }
        return idle;
    }

    public void invalidateObject(Object obj) throws Exception {
        PoolableObject poolableObject = (PoolableObject) obj;
        ObjectPool pool = poolableObject.getObjectPool();
        pool.invalidateObject(obj);
    }

    public void returnObject(Object obj) throws Exception {
        PoolableObject poolableObject = (PoolableObject) obj;
        ObjectPool pool = poolableObject.getObjectPool();
        pool.returnObject(obj);
    }

    public void setFactory(PoolableObjectFactory factory) throws IllegalStateException, UnsupportedOperationException {
        throw new UnsupportedOperationException("setFactory is not supported in class="+ this.getClass().getName());
    }

    public int getIndex() {
		return index;
	}

	public void setIndex(int index) {
		this.index = index;
	}

	public boolean isEnable() {
        return enable;
    }

    public void setEnable(boolean isEnabled) {
        this.enable = isEnabled;
    }

	public boolean isValid() {
		return this.valid;
	}

	public void setValid(boolean valid) {
		this.valid = valid;
	}

	public static class MultipleHeartbeatDelayed extends ObjectPoolHeartbeatDelayed {

		public MultipleHeartbeatDelayed(long nsTime, TimeUnit timeUnit,
				MultipleLoadBalanceObjectPool pool) {
			super(nsTime, timeUnit, pool);
		}
		
		public boolean isCycle(){
			return true;
		}
		
		public Status doCheck() {
			return super.doCheck();
		}
	}
	
	MultipleHeartbeatDelayed delayed = new MultipleHeartbeatDelayed(3, TimeUnit.SECONDS, this);
	
	public void init() {
		HeartbeatManager.addHeartbeat(delayed);
		for(ObjectPool pool :this.objectPools){
			Object conn = null;
			try {
				conn = pool.borrowObject();
			} catch (Exception e) {
			}finally{
				if(conn != null){
					try {
						pool.returnObject(conn);
					} catch (Exception e) {
					}
				}
			}
		}
		
		validate();
	}

	public void close() throws Exception {
		HeartbeatManager.removeHeartbeat(delayed);
	 }
	 
	public synchronized boolean validate() {
		List<ObjectPool> poolList = new ArrayList<ObjectPool>();
		SortedMap<Integer, ObjectPool> hashPool = new TreeMap<Integer, ObjectPool>(); 
		
		for(int i=0;i < objectPools.length;i++){
			if(objectPools[i].isValid()){
				poolList.add(objectPools[i]);
				hashPool.put(((HashMod / objectPools.length) * i), objectPools[i]);
			}
    	}
		
		ObjectPool[] poolsTemp = runtimeObjectPools = poolList.toArray(new ObjectPool[poolList.size()]);
		SortedMap<Integer, ObjectPool> oldPool = this.circle;
		this.circle = hashPool;
		oldPool.clear();
        if (poolsTemp.length == 0) {
            return false;
        }else{
        	return true;
        }
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;;
	}
}
