/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.common.bean.type;

import com.meidusa.toolkit.common.bean.type.Primitives;
import com.meidusa.toolkit.common.bean.type.TypeUtils;
import java.lang.reflect.Type;
import java.util.Collection;

class TypeInfo {
    protected final Type actualType;
    protected final Class<?> rawClass;

    TypeInfo(Type actualType) {
        this.actualType = actualType;
        this.rawClass = TypeUtils.toRawClass(actualType);
    }

    public final Type getActualType() {
        return this.actualType;
    }

    public final Class<?> getWrappedClass() {
        return Primitives.wrap(this.rawClass);
    }

    public final Class<?> getRawClass() {
        return this.rawClass;
    }

    public final boolean isCollectionOrArray() {
        return Collection.class.isAssignableFrom(this.rawClass) || this.isArray();
    }

    public final boolean isArray() {
        return TypeUtils.isArray(this.rawClass);
    }

    public final boolean isEnum() {
        return this.rawClass.isEnum();
    }

    public final boolean isPrimitive() {
        return Primitives.isWrapperType(Primitives.wrap(this.rawClass));
    }
}

