package com.meidusa.toolkit.common.bean.config;

import java.util.Map;
import java.util.Properties;

import ognl.Ognl;
import ognl.OgnlException;

import org.apache.commons.collections.map.LRUMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.meidusa.toolkit.common.bean.BeanContext;
import com.meidusa.toolkit.common.bean.BeanContextBean;

/**
 * @author <a href=mailto:piratebase@sina.com>Struct chen</a>
 */
public class ConfigUtil {
	private static Properties properties = new Properties();
	static LRUMap lruMap = new LRUMap(10000);
	static {
		properties.putAll(System.getProperties());
	}
	
    public static void addProperties(Properties properties) {
    	ConfigUtil.properties.putAll(properties);
	}

	public static Properties getProperties() {
		return properties;
	}

	public static Object filter(String text) throws ConfigurationException {
    	Object object = null;
    	try{
    		object = filter(text, BeanContextBean.getInstance());
    	}catch(Exception e){
    	}
    	if(object == null){
    		object = filter(text, properties);
    	}
    	return object;
    }
    
    public static Object filter(String text,BeanContext context){
    	 int propStart = -1;
         int propStop = -1;
         String propName = null;
         propStart = text.indexOf("${", 0);
         if (propStart < 0) {
             return text;
         }
         
         propStop = text.indexOf("}", propStart);
         if (propStop < 0) {
        	 throw new ConfigurationException("Unterminated property: " + text.substring(propStart));
         }
         
         if(text.endsWith("}")){
        	 propName = text.substring(propStart + 2, propStop);
        	 return context.getBean(propName);
         }else{
        	return filter(text,properties);
         }
    }
    
    public static String filter(String text, Properties properties) throws ConfigurationException {
        // String result = "";
    	if(text == null) return null;
        StringBuilder result = new StringBuilder();
        int cur = 0;
        int textLen = text.length();
        int propStart = -1;
        int propStop = -1;
        String propName = null;
        String propValue = null;
        for (; cur < textLen; cur = propStop + 1) {
            propStart = text.indexOf("${", cur);
            if (propStart < 0) {
                break;
            }
            result.append(text.substring(cur, propStart));
            // result = result + text.substring(cur, propStart);
            propStop = text.indexOf("}", propStart);
            if (propStop < 0) {
                throw new ConfigurationException("Unterminated property: " + text.substring(propStart));
            }
            propName = text.substring(propStart + 2, propStop);
            int  index = propName.indexOf(":");
            String defValue = null;
            String key = propName;
            if(index >0){
            	key = propName.substring(0,index);
            	defValue = propName.substring(index+1);
            }
            propValue = properties.getProperty(key,defValue);
            if (propValue == null) {
                throw new ConfigurationException("No such property:" + propName);
            }
            result.append(propValue);
            // result = result + propValue;
        }
        
        String temp = result.append(text.substring(cur)).toString();
        if(temp.indexOf("${")>=0){
            temp = filter(temp, properties);
        }
        // result = result + text.substring(cur);
        return temp;
    }
    
    public static String filterWtihOGNL(String text, Map<String,Object> context,Object root) throws ConfigurationException {
    	return filterWtihOGNL(text,context,root,System.getProperties());
    }
    
    public static String filterWtihOGNL(String text, Map<String,Object> context) throws ConfigurationException {
    	return filterWtihOGNL(text,context,new Object(),System.getProperties());
    }
    
    
    public static String filterWtihOGNL(String text, Map<String,Object> context,Object root,Properties properties) throws ConfigurationException {
        // String result = "";
    	if(properties == null){
    		properties = System.getProperties();
    	}
        StringBuilder result = new StringBuilder();
        int cur = 0;
        int textLen = text.length();
        int propStart = -1;
        int propStop = -1;
        String propName = null;
        String propValue = null;
        for (; cur < textLen; cur = propStop + 1) {
            propStart = text.indexOf("${", cur);
            if (propStart < 0) {
                break;
            }
            result.append(text.substring(cur, propStart));
            // result = result + text.substring(cur, propStart);
            propStop = text.indexOf("}", propStart);
            if (propStop < 0) {
                throw new ConfigurationException("Unterminated property: " + text.substring(propStart));
            }
            propName = text.substring(propStart + 2, propStop);
            if(propName.startsWith("#") || propName.startsWith("@")){
				try {
					Object tree = lruMap.get(propName);
					if(tree == null){
						synchronized (lruMap) {
							tree = lruMap.get(propName);
							if(tree == null){
								tree = Ognl.parseExpression(propName);
								lruMap.put(propName,tree);
							}
						}
					}
					propValue = Ognl.getValue(tree, context,root).toString();
				} catch (OgnlException e) {
					throw new ConfigurationException("parseException expression="+propName,e);
				}
			}else{
				propValue = properties.getProperty(propName);
	            if (propValue == null) {
	                throw new ConfigurationException("No such property: " + propName);
	            }
			}
            result.append(propValue);
        }

        return result.append(text.substring(cur)).toString();
    }
}
